///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>

#include "CatomCamera.hxx"
#include "CatomWorld.hxx"
#include "CatomSim.hxx"

CODE_MODULE_DECLARATION( CatomCamera, CatomCamera );

using namespace std;

#define SIZE 256

unsigned char buf2[SIZE*SIZE*3]; 

void CatomCamera::newTick() {
  Point3D xyzp;
  float xyz[3];
  float hpr[3];
  bool set = false;
  bool found = false;

  if (HOSTCATOM.getID() == 10001) {
    set = true;
  }
  else {
    xyzp = HOSTCATOM.getLocation();
    xyz[0] = xyzp.getX(); 
    xyz[1] = xyzp.getY(); 
    xyz[2] = xyzp.getZ(); 
    hpr[0] = worldPtr->current_time%360;
    hpr[1] = 0;
    hpr[2] = 0;
    worldPtr->getView(xyz, hpr, gbuf);
    for (int y = 0; y < SIZE; y++) {
      for (int x = 0; x < SIZE; x++) {
        if (gbuf[(y*SIZE+x)*3+0] > (gbuf[(y*SIZE+x)*3+1] + gbuf[(y*SIZE+x)*3+2])*1.1) {
          found = true;
#if 0
          gbuf[((y)*SIZE+x)*3+0] = 255;
          gbuf[((y)*SIZE+x)*3+1] = 255;
          gbuf[((y)*SIZE+x)*3+2] = 0;
#endif
        }
      }
    }
  }

  if (HOSTCATOM.getID() == 10005) {
    memcpy(buf2, gbuf, SIZE*SIZE*3);
  }

  HOSTCATOM.setColor(set ? 255 : 0, set ? 0 : 255, found ? 255 : 0, 0);
}

void CatomCamera::endTick() {
}

void CatomCamera::oracle() {
  oracleYield();
  oracleYield();
  while (1) {
    oracleYield();
    oracleYield();
  }
}
