///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>

#include "Brownian.hxx"
#include "CatomWorld.hxx"
#include "CatomSim.hxx"

CODE_MODULE_DECLARATION( Brownian, Brownian );

using namespace std;

double Brownian::maxf = 0.0;

void Brownian::simulationStart() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  if ( maxf ) return;
  string tmp;
  tmp = worldPtr->search_key_value_list( "Brownian_maxf" );
  if ( tmp!="" ) {
    maxf = strtod( tmp.c_str(), 0 );
  } else {
    maxf = 2.0;
  }
}


void Brownian::newTick() { signpost dprdebug_block_signpost(__FILE__,__LINE__,__FUNCTION__); 
  double x,y,z;
  x = ((2.0*rand())/RAND_MAX-1.0)*maxf;
  y = ((2.0*rand())/RAND_MAX-1.0)*maxf;
  z = ((2.0*rand())/RAND_MAX-1.0)*maxf;
  HOSTCATOMSIM->magic_force = Point3D(x,y,z);
}

