// Persistence of Vision Ray Tracer Scene Description File
// File: header.pov
// Vers: 3.6
// Desc: Checkered Floor DPR World
// Date: 05/23/2005
// Auth: Casey Helfrich
//

#version 3.6;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
}

// ----------------------------------------

camera {
  right x*image_width/image_height
  location  <50,150,50>
  look_at   <50,0,50>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-100, 300, -300>
}

// ----------------------------------------

plane {               // checkered floor
  y, 0
  texture
  {
    pigment {
      checker
      color rgb 0.5
      color rgb 0.2
      scale 8.0
    }
    finish{
      diffuse 0.8
      ambient 0.1
    }
  }
}

// ------------------------------------------


sphere {                       // The Origin
  <-1,0,-1>, 0.2
  texture {
    pigment {
      color rgb <0, 0, 0>
    }
  }
}

cylinder {                     // The Axes
  <-1,0,-1>,  <-1,0,102>,  0.25
  texture {
    pigment {
      color rgb <0, 0, 0>
    }
  }
}

cylinder {
  <-1,0,-1>,  <102,0,-1>,  0.25
  texture {
    pigment {
      color rgb <0, 0, 0>
    }
  }
}

cylinder {
  <-1,0,-1>,  <-1,22,-1>,  0.25
  texture {
    pigment {
      color rgb <0, 0, 0>
    }
  }
}


// ------------------------------------------

