// Persistence of Vision Ray Tracer Scene Description File
// File: header.pov
// Vers: 3.6
// Desc: Checkered Floor DPR World
// Date: 05/23/2005
// Auth: Casey Helfrich
//

#version 3.6;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
}

// ----------------------------------------

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-100, 300, -300>
}

// ----------------------------------------

plane {               // checkered floor
  y, 0
  texture
  {
    pigment {
      checker
      color rgb 0.5
      color rgb 0.2
      scale 16.0
    }
    finish{
      diffuse 0.8
      ambient 0.1
    }
  }
}

// ------------------------------------------

camera {                 // camera
  right x*image_width/image_height
  location <0,180,-200>
  look_at <80,100,0>
}

// ------------------------------------------
