#!/usr/bin/perl

#
# usage: addlines.pl <LINES_FILE> <POVRAY_FILE>
#

########################
# Parse the command line

my $infile = "$ARGV[0]";
chomp ( $infile );
my $outfile = "$ARGV[1]";
chomp ( $outfile );

open (INFILE, "$infile") 
    or die "can't open input file";

###########################################
# Ignore header info for now, throw it away

my $line = "";
my $atData = "false";

print("RUNNING addlines.pl $infile $outfile ...\n");

while ($line=<INFILE>) {
    chomp ( $line );
    
    @arr = split(/ /, $line);
    $a = @arr[1];
    $b = @arr[2];
    $c = @arr[3];
    $x = @arr[4];
    $y = @arr[5];
    $z = @arr[6];
    
    ##########################################################
    # Create the line
    
    $outline = "cylinder {\n<$a,$b,$c>,<$x,$y,$z>, 0.1\n texture { pigment { color black } }\n}\n\n";
    
    ###############################
    # Write the objects to the file
    
    system("echo '$outline' >> $outfile");
}

close INFILE;
