/*************************************************************************
 *                                                                       *
 * Open Dynamics Engine, Copyright (C) 2001,2002 Russell L. Smith.       *
 * All rights reserved.  Email: russ@q12.org   Web: www.q12.org          *
 *                                                                       *
 * This library is free software; you can redistribute it and/or         *
 * modify it under the terms of EITHER:                                  *
 *   (1) The GNU Lesser General Public License as published by the Free  *
 *       Software Foundation; either version 2.1 of the License, or (at  *
 *       your option) any later version. The text of the GNU Lesser      *
 *       General Public License is included with this library in the     *
 *       file LICENSE.TXT.                                               *
 *   (2) The BSD-style license that is included with this library in     *
 *       the file LICENSE-BSD.TXT.                                       *
 *                                                                       *
 * This library is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the files    *
 * LICENSE.TXT and LICENSE-BSD.TXT for more details.                     *
 *                                                                       *
 *************************************************************************/

/* functions supplied and used by the platform specific code */

#ifndef __DS_INTERNAL_H
#define __DS_INTERNAL_H

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "graphics.h"

#define WINDOW_TITLE ("DPRSim (Built " __DATE__ " " __TIME__ ")" )
#define DEFAULT_TEXTURE_PATH "DATA/textures"

// for graphics (from platform)
/* these functions display an error message then exit. they take arguments
 * in the same way as printf(), except you do not have to add a terminating
 * '\n'. Debug() tries to dump core or start the debugger.
 */
/* dsPrint() prints out a message. it takes arguments in the same way as
 * printf() (i.e. you must add a '\n' at the end of every line).
 */
void dsError (char *msg, ...);
void dsDebug (char *msg, ...);
void dsPrint (char *msg, ...);
void dsPlatformReapEvents();
void dsPlatformPreStart();
void dsPlatformThreadStart();
void dsPlatformStart();
void dsPlatformTick();
void dsPlatformEnd();
void dsPlatformGetViewWrap(float xyz[3], float hpr[3], void *data);
void dsPlatformGetView(float xyz[3], float hpr[3], void *data);
extern int width, height;
extern int pwidth, pheight;
// for graphics (from event handling)
int handleKeyPress(KeySym key, bool ctrl);
void handleMouseClick(unsigned int button, int x, int y);
void handleMouseRelease(unsigned int button, int x, int y);
void handleMouseMotion(int x, int y);
// for graphics (from font)
void dsDrawTextMappedOnObject (const float pos[3], const float *color, const float scale, const char *text);
void dsDrawTextOnObject (const float pos[3], const float *color, const float scale, const char *text);
void dsDrawTextOnScreen (const float x, const float y, const float *color, const float scale, const char *text);
void dsCreateFont();

// for platform (from graphics)
void dsDrawFrame(float view_xyz[3], float view_hpr[3], int width, int height);

// for platform (from gtk)
int create_gtk_win();
int destroy_gtk_win();

//the update_widget functions are for use by the simulator to update 
//the values of widgets (in order to display information to the user)
void update_widget(string widgetName, string widgetType, float val);
void update_widget(string widgetName, string widgetType, string val);

//used to display a (modal) message popup from the simulator
void display_gtk_message(string message);
bool display_gtk_yes_no_box(string message);

//to delete a tab (either simulation (0) or builder (1)) from the notebook
void remove_notebook_page(int num);

// for event handling (from graphics)
void dsGetViewpoint(float xyz[2], float hpr[3]);
void dsMotion (int mode, int deltax, int deltay);
void convert2Dto3D (float x, float y, float selPos[4], float selVec[4]);
int dsGetNum();
void dsSetNum (int a);
int dsGetHud();
void dsSetHud (int a);
int dsGetSpeech();
void dsSetSpeech (int a);
int dsGetDrawPolyList();
void dsSetDrawPolyList(int a);
extern "C" {
int dsGetShadows();
void dsSetShadows (int a);
}
int dsGetTextures();
void dsSetTextures (int a);
extern int frame_skip_count;

// for event handling (from platform)
extern int writeframes;

#endif
