#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "DPRSim.hxx"
#include "WorldBuilder.hxx"
#include "VisManager.hxx"
#include "VisDataTransforms.hxx"

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

extern WorldBuilder builder;
extern int width;
extern int height;
extern bool showRes;


///////////////////////////
//
// MAIN INTERFACE BUTTONS
//
///////////////////////////



void on_main_window_destroy (GtkObject *object, gpointer user_data)
{
  simStop();
  gtk_main_quit();
}


void
on_runSimulation_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  simPause(!simGetPaused());
}


void
on_record_button_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  writeframes ^= 1;
  if (writeframes)
    printf("Now writing frames to PNG files\n");
}



//////////////////////
//
// FILE MENU
//
//////////////////////

void
on_view_experiment_setup1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *notebook = lookup_widget(GTK_WIDGET(menuitem), "notebook1");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 3);
}

void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  simStop();
  gtk_main_quit();
}


//////////////////////
//
// VIEW MENU
//
//////////////////////


void
on_show_resolution1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  showRes ^= 1;
}


void
on_shadows1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  dsSetShadows(dsGetShadows() ^ 1);
}


void
on_textures1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  dsSetTextures(dsGetTextures() ^ 1);
}


void
on_speech1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  dsSetSpeech(dsGetSpeech() ^ 1);
}



//////////////////////
//
// BUILDER MENU
//
//////////////////////


void
on_import_object1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *notebook = lookup_widget(GTK_WIDGET(menuitem), "notebook1");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 4);
  notebook = lookup_widget(GTK_WIDGET(menuitem), "progressNotebook");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);
  
}


void
on_save_current_world_as1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  string filename;

  // Open the .obj file chooser dialog
  GtkFileChooser * dialog = (GtkFileChooser*)gtk_file_chooser_dialog_new ("Save world as...",
						    NULL,
						    GTK_FILE_CHOOSER_ACTION_SAVE,
						    GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
						    GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
						    NULL);

#if (GTK_CHECK_VERSION(2,8,20))
  gtk_file_chooser_set_do_overwrite_confirmation(dialog, true);
#endif
  char* currentFolder = gtk_file_chooser_get_current_folder(dialog);
  string newFolder = currentFolder;
  g_free(currentFolder);
  newFolder.append("/DATA/");
  gtk_file_chooser_set_current_folder(dialog, newFolder.c_str());

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
    if(filename.find(".world") == string::npos)
      filename = filename + ".world";
    builder.saveWorldAs(filename);
  }
  gtk_widget_destroy ((GtkWidget*)dialog);
}


void
on_navigate1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  builder.setMode(-1);
}


void
on_insert1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  builder.setMode(0);
}


void
on_erase1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  builder.setMode(1);
}


void
on_select1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  builder.setMode(2);
}


void
on_cubic1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    builder.setLattice("cubic");
}


void
on_hex_planar1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   builder.setLattice("hexp");
}


void
on_face_center_cubic1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    builder.setLattice("fcc");
}


void
on_body_center_cubic1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    builder.setLattice("bcc");
}


void
on_reset_guids__1n_1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //Inform the user that this will redo all GUIDs
  GtkWidget * dialog = gtk_message_dialog_new ((GtkWindow*)gtk_widget_get_toplevel((GtkWidget*)menuitem),
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_WARNING,
				   GTK_BUTTONS_YES_NO,
				   "This action will reset all GUIDs so that the catoms are numbered from 1 to the number of catoms. Continue?");
  gint response = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);

  //if they said yes, go ahead and clear
  if(response == GTK_RESPONSE_YES) {
    builder.requestOrganizeGUIDs();
  }
}


void
on_choose_catom_color1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{


  GtkWidget *colorbutton = lookup_widget(GTK_WIDGET(menuitem), "colorbutton");
  GdkColor *c = new GdkColor();
  gtk_color_button_get_color(GTK_COLOR_BUTTON(colorbutton), c);
  builder.setColor((int)(c->red),(int)(c->green), (int)(c->blue));
  delete c;
}

void
on_stamp_mode1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  builder.setStampMode(builder.getStampMode() ^ 1);
}


void
on_clear_all1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  //Inform the user that this will clear their previous work
  GtkWidget * dialog = gtk_message_dialog_new ((GtkWindow*)gtk_widget_get_toplevel((GtkWidget*)menuitem),
					       GTK_DIALOG_DESTROY_WITH_PARENT,
					       GTK_MESSAGE_WARNING,
					       GTK_BUTTONS_YES_NO,
					       "This action will clear the world of catoms. Continue?");
  gint response = gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
  
  //if they said yes, go ahead and clear
  if(response == GTK_RESPONSE_YES) {
    builder.clearAll();
  }
}



//////////////////////
//
// HISTORIAN MENU
//
//////////////////////


void
on_activate_historian1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *notebook = lookup_widget(GTK_WIDGET(menuitem), "notebook1");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 1);

  notebook = lookup_widget(GTK_WIDGET(menuitem), "progressNotebook");
  gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), page?0:1);
}


void
on_historyExplorer_value_changed       (GtkRange        *range,
                                        gpointer         user_data)
{
  int val = (int)gtk_range_get_adjustment(range)->value;
  worldPtr->render_time = (val < 1) ? -1 : val;
  visManagerPtr->setDisplayTick(worldPtr->render_time);
}



void
on_transformButton_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  // Get the new transform

  GtkWidget * transformInput = lookup_widget(GTK_WIDGET(button), "transformInput");
  const gchar* trans = gtk_entry_get_text(GTK_ENTRY(transformInput));

  // Place it in the transform list

  GtkWidget * transforms = lookup_widget(GTK_WIDGET(button), "transforms");
  GtkTextBuffer * buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(transforms));
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(buffer), trans,-1);
  gtk_text_buffer_insert_at_cursor(GTK_TEXT_BUFFER(buffer), "\n",-1);
}

static void
hookUpInputs(VisDataTransform* transform, string configString, VisDataTransform* transforms[]) {
  transform->detachAllInputs();
  while(configString != "") {
    // Find the '='; everything before it is the input name
    string::size_type pos = configString.find("=", 0);
    if(pos == string::npos) {
      cerr << "Couldn't find '=' in: " << configString << endl;
      return;
    }
    string inputName = configString.substr(0, pos);
    // trim off the input name and '='
    configString = configString.substr(pos+1, configString.length()-pos-1);

    // Find source
    VisDataTransform* source = NULL;
    if(configString[0] == 'i') {
      source = visManagerPtr->getStdInput();
    } else if(configString[1] == '1') {
      source = transforms[0];
    } else if(configString[1] == '2') {
      source = transforms[1];
    } else if(configString[1] == '3') {
      source = transforms[2];
    } else {
      cerr << "Couldn't parse config string for source: " << configString << endl;
      return;
    }
    // Cut off first 3 characters: t#.
    configString = configString.substr(3, configString.length()-3);

    // See if there's a comma, or whether this is the last entry
    pos = configString.find(",",0);
    string outputName;
    if(pos == string::npos) {
      // it's the last one
      outputName = configString;
      configString = "";
    } else {
      // there's a comma
      outputName = configString.substr(0, pos);
      configString = configString.substr(pos+1, configString.length()-pos-1);
    }

    // Do the hookup
    transform->attachInput(inputName, source, outputName);
  }
}

void
on_returnButton2_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget * transList = lookup_widget(GTK_WIDGET(button), "transforms");
  GtkTextBuffer * buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(transList));
  static int len = gtk_text_buffer_get_line_count(GTK_TEXT_BUFFER(buffer));
  
  cout << "There are " << len-1 << " transformations listed." << endl;
  
  static VisDataTransform* transformList[] = { NULL, NULL, NULL };
  
  // Delete old transforms
  
  for(int i = 0; i < len; i++) {
    if(transformList[i] != NULL) {
      transformList[i] = NULL;
    }
  }
  
  // Create the New Transforms and hook up inputs
  
  for (int j = 0; j < len; j++) {
    GtkTextIter * start;
    GtkTextIter * end;
    gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(buffer), start, j);
    gtk_text_buffer_get_iter_at_line(GTK_TEXT_BUFFER(buffer), end, j+1);
    gchar* tmp = (gtk_text_buffer_get_slice(GTK_TEXT_BUFFER(buffer),start,end,1));
    string tran = (tmp ? tmp : "");
    transformList[j] = visManagerPtr->newTransformWithName(tran);
    hookUpInputs(transformList[j], tran, transformList);
  }
  
  // Hook up the output's inputs
  
  VisDataTransform* stdOut = visManagerPtr->getStdOutput();
  GtkEntry * outText  = (GtkEntry*)lookup_widget(GTK_WIDGET(button), "debugOutputOptions");
  string outInputs = (gtk_entry_get_text(outText));
  hookUpInputs(stdOut, outInputs, transformList);
  
  cerr << "APPLYING transforms..." << endl;
  
  GtkWidget *notebook = lookup_widget(GTK_WIDGET(button), "notebook1");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);
}




//////////////////////
//
// HELP MENU
//
//////////////////////


void
on_keyboard_commands1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget * dialog = gtk_message_dialog_new ((GtkWindow*)gtk_widget_get_toplevel((GtkWidget*)menuitem),
					       GTK_DIALOG_DESTROY_WITH_PARENT,
					       GTK_MESSAGE_INFO,
					       GTK_BUTTONS_CLOSE,
					       "\nKeyboard Commands:\n\nCtrl-P: Pause / Unpause\nCtrl-S: Toggle Shadows\nCtrl-W: Write frames to disk as .png files\nCtrl-E: Toggle Catom speech bubbles\n\nCtrl-X: Quit\n\nMove the camera with the arrow keys.\nPress and hold the right mouse button to point the camera.\nClick with the left mouse button to select a Catom.\nScroll the mouse wheel to move up and down vertically.");
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}

void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget * dialog = gtk_message_dialog_new ((GtkWindow*)gtk_widget_get_toplevel((GtkWidget*)menuitem),
					       GTK_DIALOG_DESTROY_WITH_PARENT,
					       GTK_MESSAGE_INFO,
					       GTK_BUTTONS_CLOSE,
					       "Author: Casey Helfrich [casey.j.helfrich@intel.com]\n\nContributors: Michael Ryan, Daniel Dewey, Ben Rister, Seth Goldstein, Babu Pillai, and many more...\n\nhttp://www.pittsburgh.intel-research.net/dprweb/\nfor more info.");
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}


////////////////////////////////
//
// EXPERIMENT INFO TAB
//
////////////////////////////////

void
on_returnToSim_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *notebook = lookup_widget(GTK_WIDGET(button), "notebook1");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);
}


////////////////////////////////
//
//  BUILDER DIALOG TAB
//
////////////////////////////////




void
on_shellFillButton_toggled             (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{
  if(gtk_toggle_tool_button_get_active(toggletoolbutton))
    builder.setFillStyle(false);
}


void
on_solidFillButton_toggled             (GtkToggleToolButton *toggletoolbutton,
                                        gpointer         user_data)
{
  if(gtk_toggle_tool_button_get_active(toggletoolbutton))
    builder.setFillStyle(true);
}


void
on_objectButton_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget * object = lookup_widget(GTK_WIDGET(button), "objectFile");
  char *filename;

  // Open the .obj file chooser dialog
  GtkFileChooser * dialog = (GtkFileChooser*)gtk_file_chooser_dialog_new ("Choose 3D Model File (obj, stl)",
						    NULL,
						    GTK_FILE_CHOOSER_ACTION_OPEN,
						    GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
						    GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
						    NULL);

  char* currentFolder = gtk_file_chooser_get_current_folder(dialog);
  string newFolder = currentFolder;
  g_free(currentFolder);
  newFolder.append("/DATA/");
  gtk_file_chooser_set_current_folder(dialog, newFolder.c_str());

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) {
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
    gtk_entry_set_text(GTK_ENTRY(object),filename);
  }
  else {
      gtk_widget_destroy ((GtkWidget*)dialog);
      return;
  }
  gtk_widget_destroy ((GtkWidget*)dialog);
  // End Open the .obj file chooser dialog

  // Check to see if filename is valid

  FILE * file;
  if( ( file = fopen(filename, "r") ) == NULL ) {
    fclose(file);
    return;
  }
  
  // End Check to see if filename is valid

  fclose(file);
  // Close the file

  g_free (filename);
}


void
on_clearObjectButton_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget * object = lookup_widget(GTK_WIDGET(button), "objectFile");
  gtk_entry_set_text(GTK_ENTRY(object),"");
}


void
on_importObjectButton_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *notebook = lookup_widget(GTK_WIDGET(button), "notebook1");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);

  GtkEntry *file = (GtkEntry*)lookup_widget(GTK_WIDGET(button), "objectFile");
  string filename(gtk_entry_get_text(file));
  
  GtkSpinButton *scale = (GtkSpinButton*)lookup_widget(GTK_WIDGET(button), "catomScale");
  int size = (gtk_spin_button_get_value_as_int(scale));
  
  GtkToggleButton *flip = (GtkToggleButton*)lookup_widget(GTK_WIDGET(button), "flipYZ");
  bool flipYZ = (gtk_toggle_button_get_active(flip));
  
  bool iac = builder.getStampMode();
  
  GtkSpinButton * shell  = (GtkSpinButton*)lookup_widget(GTK_WIDGET(button), "shellThickness");
  int thickness = (gtk_spin_button_get_value_as_int(shell));
  
  builder.import(filename, size, thickness, flipYZ, iac);

  notebook = lookup_widget(GTK_WIDGET(button), "progressNotebook");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 2);

}



void
on_createPrism_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget *notebook = lookup_widget(GTK_WIDGET(button), "notebook1");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);

  bool iac = builder.getStampMode();
  
  GtkSpinButton * shell  = (GtkSpinButton*)lookup_widget(GTK_WIDGET(button), "shellThickness");
  int thickness = (gtk_spin_button_get_value_as_int(shell));

  vector<float> params;
  GtkSpinButton * w  = (GtkSpinButton*)lookup_widget(GTK_WIDGET(button), "boxWidth");
  params.push_back(gtk_spin_button_get_value_as_int(w));

  GtkSpinButton * d  = (GtkSpinButton*)lookup_widget(GTK_WIDGET(button), "boxDepth");
  params.push_back(gtk_spin_button_get_value_as_int(d));

  GtkSpinButton * h  = (GtkSpinButton*)lookup_widget(GTK_WIDGET(button), "boxHeight");
  params.push_back(gtk_spin_button_get_value_as_int(h));
  
  builder.requestPrimitive("box", params, thickness, false, iac);

}


void
on_cancelButton_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{

  GtkWidget *notebook = lookup_widget(GTK_WIDGET(button), "notebook1");
  gtk_notebook_set_current_page(GTK_NOTEBOOK(notebook), 0);
}


