//#define BOOST_SPIRIT_DEBUG 
#include <algorithm>
#include <boost/spirit/core.hpp>
#include <boost/spirit/tree/ast.hpp>
#include <boost/spirit/tree/tree_to_xml.hpp>
#include <string>
#include <iostream>
#include <map>
#include <boost/any.hpp>
#include <stdlib.h>
#include <typeinfo>
#include "WPParser.hxx"
#include "WPManager.hxx"
#include "CatomSim.hxx"
#include "CodeModules/DistributedWatchpoint.hxx"
using namespace std;
using namespace boost::spirit;
using namespace boost;

pthread_mutex_t wp_debug_lock = PTHREAD_MUTEX_INITIALIZER;

typedef char const*         iterator_t;
typedef tree_match<iterator_t> parse_tree_match_t;
typedef parse_tree_match_t::tree_iterator iter_t;
any evaluate(parse_tree_match_t hit);
any eval_expression(iter_t const& i);


////////////////////////////////////////////////////////////////////////////
//
//  Our watchpoint grammar
//
////////////////////////////////////////////////////////////////////////////
struct wp_grammar : public grammar<wp_grammar>
{
	static const int watchpointID = 1;
	//data types
	static const int actionID = 2;
	static const int identifierID = 3;
	static const int numericID = 4;
	//module access
	static const int moduleListID = 5;
	static const int moduleID = 6;
	static const int moduleHelperID = 7;
	static const int stateVarID = 8;
	//boolean expressions
	static const int boolExpID = 9;
	static const int boolExpSimpleID = 10;
	static const int compExpID = 11;
	static const int compOpID = 12;
	//float expressions
	static const int realExpID = 13;
	static const int mathOpID = 14;

		template <typename ScannerT>
		struct definition
		{
				definition(wp_grammar const& /*self*/)
				{
			//  Start grammar definition
			wp = infix_node_d[moduleList >> ';' >> boolExp >> ';' >> action];
			
			//action = str_p("halt") | str_p("count") | str_p("arrows");
			action = lexeme_d[token_node_d[*alpha_p]];
			identifier = lexeme_d[token_node_d[alpha_p >> *('_'|alnum_p|':')]];
			numeric = real_p;
			
			moduleList = ch_p('(') >> infix_node_d[identifier % ','] >> ch_p(')');
			module = identifier >> !moduleHelper;
			moduleHelper = +(str_p(".last") | str_p(".next"));
			stateVar = module >> '.' >> identifier;
			
			boolExp = (boolExpSimple >> (ch_p('&') | ch_p('|')) >> boolExp) 
					| boolExpSimple;
			boolExpSimple = (ch_p('!') >> boolExpSimple)
					| (ch_p('n') >> '(' >> identifier >> ',' >> identifier >> ')')
					| ('(' >> compExp >> ')') | ('(' >> boolExp >> ')');
			compExp = realExp >> compOp >> realExp;
			compOp = str_p(">=") | str_p(">") | str_p("==") | str_p("<=") | str_p("<") | str_p("!=");
	
			realExp = stateVar | numeric | ('(' >> realExp >> mathOp >> realExp >> ')'); 
			mathOp = str_p("+") | str_p("-") | str_p("*") | str_p("/");
			//  End grammar definition
			//BOOST_SPIRIT_DEBUG_RULE(exp);
			//BOOST_SPIRIT_DEBUG_RULE(expSimple);
				}

				rule<ScannerT, parser_context<>, parser_tag<watchpointID> >   wp;
				rule<ScannerT, parser_context<>, parser_tag<moduleListID> >   moduleList;
				rule<ScannerT, parser_context<>, parser_tag<boolExpID> >      boolExp;
				rule<ScannerT, parser_context<>, parser_tag<boolExpSimpleID> >boolExpSimple;
				rule<ScannerT, parser_context<>, parser_tag<moduleID> >       module;
				rule<ScannerT, parser_context<>, parser_tag<moduleHelperID> > moduleHelper;
				rule<ScannerT, parser_context<>, parser_tag<stateVarID> >     stateVar;
				rule<ScannerT, parser_context<>, parser_tag<compExpID> >      compExp;
				rule<ScannerT, parser_context<>, parser_tag<compOpID> >       compOp;
				rule<ScannerT, parser_context<>, parser_tag<identifierID> >   identifier;
				rule<ScannerT, parser_context<>, parser_tag<numericID> >      numeric;
				rule<ScannerT, parser_context<>, parser_tag<actionID> >       action;
				rule<ScannerT, parser_context<>, parser_tag<mathOpID> >       mathOp;
				rule<ScannerT, parser_context<>, parser_tag<realExpID> >      realExp;

				rule<ScannerT, parser_context<>, parser_tag<watchpointID> > const&
				start() const { return wp; }
		};
};

any evaluate(tree_parse_info<> info)
{
		return eval_expression(info.trees.begin());
}

//needed if we put a derived class in, but want a base class out
BoolExp *decodeAny(any a) {
	if (BoolExp **e = any_cast<BoolExp*>(&a)) return *e;
	else if (AndExp **e = any_cast<AndExp*>(&a)) return *e;
	else if (OrExp **e = any_cast<OrExp*>(&a)) return *e;
	else if (NotExp **e = any_cast<NotExp*>(&a)) return *e;
	else if (CompExp **e = any_cast<CompExp*>(&a)) return *e;
	else if (NeighborExp **e = any_cast<NeighborExp*>(&a)) return *e;
	cout << "no match in decodeAny:" << a.type().name() << endl;
	return NULL;
}

RVal *decodeAny2(any a) {
	if (RVal **e = any_cast<RVal*>(&a)) return *e;
	else if (Number **e = any_cast<Number*>(&a)) return *e;
	else if (CatomVar **e = any_cast<CatomVar*>(&a)) return *e;
	else if (MathExp **e = any_cast<MathExp*>(&a)) return *e;
	cout << "no match in decodeAny2:" << a.type().name() << endl;
	return NULL;
}

any eval_expression(iter_t const& i) {
	//cout << i->value.id().to_long() << endl;
	//do construction of matcher object here
	switch (i->value.id().to_long()) {
		case wp_grammar::watchpointID:
			assert(i->children.size() == 3);
			return any(new Watchpoint(
									any_cast<CatomList*>(eval_expression(i->children.begin())),
									decodeAny(eval_expression(i->children.begin()+1)),
									any_cast<WatchpointAction>(eval_expression(i->children.begin()+2))));
		case wp_grammar::moduleListID: {
				CatomList *cl = new CatomList();
				for (unsigned j = 1; j < i->children.size() -1; j++) {
					string s(i->children[j].value.begin(),i->children[j].value.end());
					cl->addName(s.c_str());
				}
				return any(cl);
			}
		case wp_grammar::identifierID:
			return any(string(i->value.begin(), i->value.end()));	
		case wp_grammar::boolExpSimpleID: {
			BoolExp *head;
			if (*i->children[0].value.begin() == '!')
					{
				head = new NotExp(any_cast<BoolExp*>(eval_expression(i->children.begin()+1)));
			}
			else if (*i->children[0].value.begin() == 'n')
					{
				head = new NeighborExp((any_cast<string>(eval_expression(i->children.begin()+2))).c_str(),
												(any_cast<string>(eval_expression(i->children.begin()+4))).c_str());
			}
			else if (i->children[1].value.id() == wp_grammar::boolExpID) {
				head = decodeAny(eval_expression(i->children.begin()+1));
			}
			else {
				head = any_cast<CompExp*>(eval_expression(i->children.begin()+1));
			}
			return any(head);
		}
		case wp_grammar::boolExpID:
			if (i->children.size() == 3) {
				if (*i->children[1].value.begin() == '&')
						{
					return any(new AndExp(decodeAny(eval_expression(i->children.begin())),
												decodeAny(eval_expression(i->children.begin()+2)))); 
				}
				else {
					return any(new OrExp(decodeAny(eval_expression(i->children.begin())),
												decodeAny(eval_expression(i->children.begin()+2))));
				}
			}
			else {
				return eval_expression(i->children.begin());
			}
		case wp_grammar::moduleID: {
				string name(i->children[0].value.begin(),i->children[0].value.end());
				CatomRef *cr = new CatomRef(name.c_str());
				cr->temporalOffset =  any_cast<int>(eval_expression(i->children.begin()+1));
				return any(cr);
			}
		case wp_grammar::moduleHelperID: {
				int to = 0;
				//check moduleHelper's value
				string s(i->value.begin(),i->value.end());
				if (s == ".next") to++;
				else if (s == ".last") to--;
				//iterate through children
				for (unsigned j = 0; j < i->children.size(); j++) {
					string s(i->children[j].value.begin(),i->children[j].value.end());
					if (s == ".next") to++;
					else to--;
				}
				return any(to);
			}
		case wp_grammar::stateVarID: 
				if (i->children[0].value.id() == wp_grammar::identifierID) 
					return any(new CatomVar(new CatomRef((any_cast<string>(eval_expression(i->children.begin()))).c_str()),
														(any_cast<string>(eval_expression(i->children.begin()+2))).c_str()));
				else 
					return any(new CatomVar(any_cast<CatomRef*>(eval_expression(i->children.begin())),
													(any_cast<string>(eval_expression(i->children.begin()+2))).c_str()));
		case wp_grammar::compExpID: {
			return any(new CompExp(decodeAny2(eval_expression(i->children.begin())),
									(any_cast<string>(eval_expression(i->children.begin()+1))).c_str(),
									decodeAny2(eval_expression(i->children.begin()+2))));
		}
		case wp_grammar::realExpID: {
			if (i->children.size() == 5) {
				return any(new MathExp(decodeAny2(eval_expression(i->children.begin()+1)),
										(any_cast<string>(eval_expression(i->children.begin()+2))).c_str(),
										decodeAny2(eval_expression(i->children.begin()+3))));
			}
			else {
				return eval_expression(i->children.begin());
			}
		}
		case wp_grammar::compOpID:
			return any(string(i->value.begin(), i->value.end()));
		case wp_grammar::mathOpID:
			return any(string(i->value.begin(), i->value.end()));	
		case wp_grammar::numericID: {
			string s(i->value.begin(), i->value.end());
			return any(new Number(atof(s.c_str())));
		}
		case wp_grammar::actionID: {
			string s(i->value.begin(),i->value.end());
			if (s == "halt") return any(Act_Halt);
			else if (s == "count") return any(Act_Count);
			else if (s == "nothing") return any(Act_Nothing);
			else if (s == "arrows") return any(Act_Arrows);
			else if (s == "color") return any(Act_Color);
			else {	
				cout << "unknown action: " << s << endl;
				return any(Act_Halt); //default action: halt
			}
		}
		default:
			cout << "default: empty " << i->value.id().to_long() << endl;
			return any();
	}
}

Watchpoint *parseWP(string input) {
	wp_grammar wp;
	cout << "Parser input:" << input << endl;
	tree_parse_info<> info = ast_parse(input.c_str(), wp,space_p);	
	if (info.full)
		{
				// dump parse tree as XML		
		std::map<parser_id, std::string> rule_names;
			rule_names[wp_grammar::watchpointID] = "watchpoint";
		rule_names[wp_grammar::moduleListID] = "list";
		rule_names[wp_grammar::boolExpID] = "boolExp";
		rule_names[wp_grammar::boolExpSimpleID] = "boolExpSimple";
		rule_names[wp_grammar::moduleID] = "module";
		rule_names[wp_grammar::moduleHelperID] = "moduleHelper";
		rule_names[wp_grammar::stateVarID] = "stateVar";
		rule_names[wp_grammar::realExpID] = "realExp";
		rule_names[wp_grammar::compExpID] = "compExp";
		rule_names[wp_grammar::compOpID] = "compOp";
		rule_names[wp_grammar::identifierID] = "identifier";
		rule_names[wp_grammar::numericID] = "numeric";
		rule_names[wp_grammar::actionID] = "action";
		rule_names[wp_grammar::mathOpID] = "mathOp";
		//tree_to_xml(cout, info.trees, input.c_str(), rule_names);
		

				// print the result
				//cout << "parsing succeeded\n";
		return any_cast<Watchpoint*>(evaluate(info));
		}
		else
		{
				cout << "watchpoint parsing failed\n";
		return NULL;
		}
}

CatomSim *Watchpoint::nextRoutingStep(CatomSim *curr) {
	//calculate the next catom to send to, given adjacency matrix, destination, & curr location
	//get source and dest #'s
	int sourceIdx,destIdx;
	for (int i = 0; i < (int)c_list->names.size(); i++) {
		if (c_list->names[i].second) {
			if (c_list->names[i].second == curr) sourceIdx = i;
			if (c_list->names[i].second == destination) destIdx = i;
		}
	}
	//queue of actives, set of visited
	deque<int> active;
	set<int> visited;
	//push dest on to queue
	active.push_back(destIdx);
	//pop currIdx off of queue...
	while (active.size()) {
		int currIdx = active.front();
		active.pop_front();
		//add to currIdx to visited set
		visited.insert(currIdx);
		//for each entry j in adjacency matrix for currIdx...
		for (int j = 0; j < (int)c_list->names.size(); j++) {
			//if j is adjacent...
			if (adjacency[currIdx][j]) {
				//if j is source, return CatomId for currIdx
				if (j == sourceIdx) {
					return c_list->names[currIdx].second;
				}
				//else, if j not in queue or visited set, push j on to queue
				deque<int>::iterator result = find(active.begin(), active.end(), j);
				if ((result == active.end()) && (visited.find(j) == visited.end())) active.push_back(j);
			}
		}
	}
	cout << "No route found. Badness will ensue." << endl;
	return NULL;
}


//traversal routines:=============================================================
void CompExp::propagate(string name,CatomSim *catom,WPManager *wm){
	lval->propagate(name,catom,wm);
	rval->propagate(name,catom,wm);
}
void CompExp::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp){
	lval->propagate(name,catom,wp);
	rval->propagate(name,catom,wp);
}
void MathExp::propagate(string name,CatomSim *catom,WPManager *wm){
	lval->propagate(name,catom,wm);
	rval->propagate(name,catom,wm);
}
void MathExp::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp){
	lval->propagate(name,catom,wp);
	rval->propagate(name,catom,wp);
}
void AndExp::propagate(string name,CatomSim *catom,WPManager *wm){
	lval->propagate(name,catom,wm);
	rval->propagate(name,catom,wm);
}
void AndExp::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp){
	lval->propagate(name,catom,wp);
	rval->propagate(name,catom,wp);
}
void OrExp::propagate(string name,CatomSim *catom,WPManager *wm){
	lval->propagate(name,catom,wm);
	rval->propagate(name,catom,wm);
}
void OrExp::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp){
	lval->propagate(name,catom,wp);
	rval->propagate(name,catom,wp);
}
void NotExp::propagate(string name,CatomSim *catom,WPManager *wm){val->propagate(name,catom,wm);}
void NotExp::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp){val->propagate(name,catom,wp);}
void NeighborExp::propagate(string name,CatomSim *catom,WPManager *wm) {
	if (satisfied != maybe) return;
	//fill in the relevant catom ids
	catomID currentID = catom->C.getID();
	if (name == lval) lcatom = currentID;
	if (name == rval) rcatom = currentID;
	if (lcatom && rcatom && ((currentID == lcatom) || (currentID == rcatom))) {
		catomID remoteID = (currentID == lcatom) ? rcatom : lcatom;
		//see if currentID and remoteID are neighbors
		for (unsigned i = 0; i < NUM_FEATURES; i++) {
			if (catom->C.getNthNeighbor(i) == remoteID) {
				satisfied = yes;
				break;
			}
		}
		if (satisfied != yes) satisfied = no;
	}
}
void NeighborExp::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp) {
	if (satisfied != maybe) return;
	//fill in the relevant catom ids
	catomID currentID = catom->C.getID();
	if (name == lval) lcatom = currentID;
	if (name == rval) rcatom = currentID;
	if (lcatom && rcatom && ((currentID == lcatom) || (currentID == rcatom))) {
		catomID remoteID = (currentID == lcatom) ? rcatom : lcatom;
		//see if currentID and remoteID are neighbors
		for (unsigned i = 0; i < NUM_FEATURES; i++) {
			if (catom->C.getNthNeighbor(i) == remoteID) {
				satisfied = yes;
				break;
			}
		}
		if (satisfied != yes) satisfied = no;
	}
}
void CatomVar::propagate(string name,CatomSim *catom,WPManager *wm){
	if (name == catomref->name) {
		filled = true;
		value = wm->lookupSavedState(catom,var,catomref->temporalOffset);
	}
}


void CatomVar::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp){
	if (name == catomref->name) {
		filled = true;
		value = wp->lookupSavedState(var,catomref->temporalOffset);
	}
}

void CatomList::propagate(string name,CatomSim *catom,WPManager *wm) {
	for (unsigned i =0; i < names.size(); i++) {
		if (names[i].first == name) {
			names[i].second = catom;
			return;
		}
	}
}
void CatomList::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp) {
	for (unsigned i =0; i < names.size(); i++) {
		if (names[i].first == name) {
			names[i].second = catom;
			return;
		}
	}
}

void Watchpoint::propagate(string name,CatomSim *catom,WPManager *wm) {
	c_list->propagate(name,catom,wm);
	main_exp->propagate(name,catom,wm);
}
void Watchpoint::propagate(string name,CatomSim *catom,DistributedWatchpoint *wp) {
	c_list->propagate(name,catom,wp);
	main_exp->propagate(name,catom,wp);
	//add adjacency edges
	int idx1 = c_list->slotIdx(catom);
	for (unsigned i = 0; i < NUM_FEATURES; i++) {
		catomID currNeighbor = catom->C.getNthNeighbor(i);
		if (currNeighbor) {
			int idx2 = c_list->slotIdx(worldPtr->catomHash[currNeighbor]);
			if ((idx1 >= 0) & (idx2 >= 0)) {
				adjacency[idx1][idx2] = 1;
				adjacency[idx2][idx1] = 1;
			}
		}
	}
}

//clone-------------------------
NotExp *NotExp::clone() {return new NotExp(val->clone());}
OrExp *OrExp::clone() {return new OrExp(lval->clone(),rval->clone());}	
AndExp *AndExp::clone() {return new AndExp(lval->clone(),rval->clone());}
CompExp *CompExp::clone() {return new CompExp(lval->clone(),op.c_str(),rval->clone());}
MathExp *MathExp::clone() {return new MathExp(lval->clone(),op.c_str(),rval->clone());}
Number *Number::clone() {return new Number(value);}
CatomVar *CatomVar::clone() {
	CatomVar *cv = new CatomVar(catomref->clone(),var.c_str());
	cv->filled = filled;
	cv->value = value;
	return cv;
}
CatomRef *CatomRef::clone() {
	CatomRef *newRef = new CatomRef(name.c_str());
	newRef->temporalOffset = temporalOffset;
	return newRef;
}
NeighborExp *NeighborExp::clone() {
	NeighborExp *myClone = new NeighborExp(lval.c_str(),rval.c_str());
	myClone->lcatom = this->lcatom;
	myClone->rcatom = this->rcatom;
	myClone->satisfied = this->satisfied;
	return myClone;
}
CatomList *CatomList::clone() {
	CatomList *newCL = new CatomList();
	for (unsigned i = 0; i < names.size(); i++) {
		pair<string,CatomSim *> newPr(names[i].first,names[i].second);
		newCL->names.push_back(newPr);
	}
	return newCL;
}
Watchpoint *Watchpoint::clone() {
	Watchpoint *c = new Watchpoint(c_list->clone(),main_exp->clone(),action);
	c->inTransit = this->inTransit;
	c->destination = this->destination;
	c->adjSize = this->adjSize;
	c->id = this->id;
	for (int i = 0; i < adjSize; ++i)
		for (int j = 0; j < adjSize; ++j)
			c->adjacency[i][j] = this->adjacency[i][j];
	return c;
}

//tShift------------------------
void Watchpoint::tShift() {main_exp->tShift();}
void NotExp::tShift() {val->tShift();}
void OrExp::tShift() { lval->tShift(); rval->tShift(); }
void AndExp::tShift() { lval->tShift(); rval->tShift(); }
void CompExp::tShift() { lval->tShift();rval->tShift(); }
void MathExp::tShift() { lval->tShift();rval->tShift(); }
void CatomVar::tShift() {	if (!filled) catomref->tShift(); }
void CatomRef::tShift() {temporalOffset--;}

//watchedVariables--------------
set<string> NotExp::watchedVariables() { 	return val->watchedVariables(); }
set<string> OrExp::watchedVariables() { 
	set<string> l = lval->watchedVariables(); 
	set<string> r = rval->watchedVariables(); 
	set<string> u;
	set_union(l.begin(),l.end(),r.begin(),r.end(),inserter(u,u.end()));
	return u;
}
set<string> AndExp::watchedVariables() { 
	set<string> l = lval->watchedVariables(); 
	set<string> r = rval->watchedVariables(); 
	set<string> u;
	set_union(l.begin(),l.end(),r.begin(),r.end(),inserter(u,u.end()));
	return u;
}
set<string> CompExp::watchedVariables() { 
	set<string> l = lval->watchedVariables(); 
	set<string> r = rval->watchedVariables(); 
	set<string> u;
	set_union(l.begin(),l.end(),r.begin(),r.end(),inserter(u,u.end()));
	return u;
}
set<string> MathExp::watchedVariables() { 
	set<string> l = lval->watchedVariables(); 
	set<string> r = rval->watchedVariables(); 
	set<string> u;
	set_union(l.begin(),l.end(),r.begin(),r.end(),inserter(u,u.end()));
	return u;
}
set<string> CatomVar::watchedVariables() { 
	set<string> s; 
	s.insert(var); 
	return s;
}
set<string> Watchpoint::watchedVariables() { return main_exp->watchedVariables();}

//minExtent/maxExtent--------------------------
int NotExp::minExtent(string name) {return val->minExtent(name);}	
int NotExp::maxExtent(string name) {return val->maxExtent(name);}
int OrExp::minExtent(string name) {
	if (lval->minExtent(name) < rval->minExtent(name)) return lval->minExtent(name);
	else return rval->minExtent(name);
}
int OrExp::maxExtent(string name) {
	if (lval->maxExtent(name) > rval->maxExtent(name)) return lval->maxExtent(name);
	else return rval->maxExtent(name);
}
int AndExp::minExtent(string name) {
	if (lval->minExtent(name) < rval->minExtent(name)) return lval->minExtent(name);
	else return rval->minExtent(name);
}
int AndExp::maxExtent(string name) {
	if (lval->maxExtent(name) > rval->maxExtent(name)) return lval->maxExtent(name);
	else return rval->maxExtent(name);
}
int MathExp::minExtent(string name) {
	if (lval->minExtent(name) < rval->minExtent(name)) return lval->minExtent(name);
	else return rval->minExtent(name);
}
int MathExp::maxExtent(string name) {
	if (lval->maxExtent(name) > rval->maxExtent(name)) return lval->maxExtent(name);
	else return rval->maxExtent(name);
}
int CompExp::minExtent(string name) {
	if (lval->minExtent(name) < rval->minExtent(name)) return lval->minExtent(name);
	else return rval->minExtent(name);
}
int CompExp::maxExtent(string name) {
	if (lval->maxExtent(name) > rval->maxExtent(name)) return lval->maxExtent(name);
	else return rval->maxExtent(name);
}
int CatomVar::minExtent(string name) {
	if (name == var) {
		return (catomref->temporalOffset < 0)? catomref->temporalOffset : 0;
	}
	else return 0;
}
int CatomVar::maxExtent(string name) {
	if (name == var) {
		return (catomref->temporalOffset > 0)? catomref->temporalOffset : 0;
	}
	else return 0;
}
int Watchpoint::minExtent(string name) {return main_exp->minExtent(name);}
int Watchpoint::maxExtent(string name) {return main_exp->maxExtent(name);}

//isValidCandidate--------------------------------
//used in centralized version only
bool NotExp::isValidCandidate(map<CatomSim*,set <CatomSim *> > &neighbors, 
															vector<pair<string,CatomSim*> > &names,
															CatomSim *candidate,const string &slotName) {
			return !(val->isValidCandidate(neighbors,names,candidate,slotName));
}
bool AndExp::isValidCandidate(map<CatomSim*,set <CatomSim *> > &neighbors, 
															vector<pair<string,CatomSim*> > &names,
															CatomSim *candidate,const string &slotName) {
			return (lval->isValidCandidate(neighbors,names,candidate,slotName) &&
							rval->isValidCandidate(neighbors,names,candidate,slotName));
}
bool OrExp::isValidCandidate(map<CatomSim*,set <CatomSim *> > &neighbors, 
															vector<pair<string,CatomSim*> > &names,
															CatomSim *candidate,const string &slotName) {
			return (lval->isValidCandidate(neighbors,names,candidate,slotName) &&
							rval->isValidCandidate(neighbors,names,candidate,slotName));
}
bool NeighborExp::isValidCandidate(map<CatomSim*,set <CatomSim *> > &neighbors, 
vector<pair<string,CatomSim*> > &names, CatomSim *candidate,const string &slotName) 
{
		if ((lval!=slotName) && (rval != slotName)) return true; //if we don't use either name, then candidate is fine
		string &filledName = (lval==slotName) ? rval : lval; //get name of filled half of n(a,b)
		for (unsigned i = 0; i < names.size(); i++) {
			if (names[i].first == filledName) {
				if (!names[i].second) return true; //"filled" half of n(a,b) exp might not be initialized
				return (neighbors[names[i].second].count(candidate) != 0); //is candidate in neighbor set of filledName?
			}
		}
		return false;
}
bool Watchpoint::isValidCandidate(map<CatomSim*,set <CatomSim *> > &neighbors, 
															vector<pair<string,CatomSim*> > &names,
															CatomSim *candidate,const string &slotName) {
	//use provided neighbor set
	return main_exp->isValidCandidate(neighbors,names,candidate,slotName);
}

//isSatisfied-------------------------------------------
TriState Number::isSatisfied(bool centralized) {return yes;}
TriState NotExp::isSatisfied(bool centralized) {
	if (val->isSatisfied(centralized) == yes) return no;
	if (val->isSatisfied(centralized) == no) return yes;
	else return maybe;
}
TriState NeighborExp::isSatisfied(bool centralized) { return satisfied;}
TriState OrExp::isSatisfied(bool centralized) {
	if ((lval->isSatisfied(centralized) == no) && (rval->isSatisfied(centralized) == no)) return no;
	if ((lval->isSatisfied(centralized) == yes) || (rval->isSatisfied(centralized) == yes)) return yes;
	else return maybe;
}
TriState AndExp::isSatisfied(bool centralized) {
	if ((lval->isSatisfied(centralized) == yes) && (rval->isSatisfied(centralized) == yes)) return yes;
	else if ((lval->isSatisfied(centralized) == no) || (rval->isSatisfied(centralized) == no)) return no;
	else return maybe;
}
TriState CompExp::isSatisfied(bool centralized) {
	if ((lval->isSatisfied(centralized) == yes) && (rval->isSatisfied(centralized) == yes)) {
		//cout << lval->value << op << rval->value << endl;
		if (op == "==") {
			if (lval->value == rval->value) return yes;
			else return no;
		}
		else if (op == "!=") {
			if (lval->value != rval->value) return yes;
			else return no;
		}
		else if (op == ">=") {
			if (lval->value >= rval->value) return yes;
			else return no;
		}
		else if (op == "<=") {
			if (lval->value <= rval->value) return yes;
			else return no;
		}
		else if (op == ">") {
			if (lval->value > rval->value) return yes;
			else return no;
		}
		else if (op == "<") {
			if (lval->value < rval->value) return yes;
			else return no;
		}
		else {
			cout << "Unknown operator:" << op << endl;
			return yes;
		}
	}
	else return maybe;
}
TriState MathExp::isSatisfied(bool centralized) {
	if ((lval->isSatisfied(centralized) == yes) && (rval->isSatisfied(centralized) == yes)) {
		if (op == "+") {
			value = lval->value + rval->value;
			return yes;
		}
		else if (op == "-") {
			value = lval->value - rval->value;
			return yes;
		}
		else if (op == "*") {
			value = lval->value * rval->value;
			return yes;
		}
		else if (op == "/") {
			value = lval->value / rval->value;
			return yes;
		}
		else {
			cout << "Unknown operator:" << op << endl;
			return yes;
		}
	}
	else return maybe;
}
TriState CatomVar::isSatisfied(bool centralized) {
	if (filled) return yes;
	else return maybe;
}
TriState Watchpoint::isSatisfied(bool centralized) {return main_exp->isSatisfied(centralized);}

// int main() {
// 	string input = "(a,d,c); n(a,b) & n(b,c) | !(d.argh != b.foo) & (b.last.next.foo > 12)";
// 	parseWP(input);
// 	return 0;
// }
