#ifndef __WP_MANAGER__
#define __WP_MANAGER__
#include <map>
#include <deque>
#include <vector>
#include "WPParser.hxx"
#include "CatomWorld.hxx"

using namespace std;

extern CatomWorld *worldPtr;

class WPManager {
public:
	unsigned long steps;
	unsigned skip;
	vector<Watchpoint *> wp_masters; //master pattern matchers for each wp
	set<string> wpNames; //variable names (over all wps)
	int max_temporal; //max future temporal extent (over all wps)
	map<string,int> minExtent; //min extent for each variable (over all wps)
	map<string,int> maxExtent; //max extent for each variable (over all wps)
	map<string,map<CatomSim *,deque<float> > > savedState; //to access catom x's var foo (current value) savedState["foo"][x][0]
	map<catomID,deque<float> > fullState;
	
	WPManager(unsigned skip);
	void addWatchpoint(string input);
	~WPManager();
	void step();
	static float getState(CatomSim *c,string name);
	set<CatomSim*> possibleNeighbors(Watchpoint *wp,map<CatomSim*,set <CatomSim *> > &n);
	float lookupSavedState(CatomSim *c,string varName,int offset);
	void addLinesForWatchpoint(Watchpoint *wp);
	void addColorForWatchpoint(Watchpoint *wp);
};

#endif //__WP_MANAGER__
