#include "WPManager.hxx"
#include "DPRSim.hxx"
#include "CodeModule.hxx"

WPManager::WPManager(unsigned _skip) {
	max_temporal = 0;
	steps = 0;
	skip = _skip;
	//set up master state save structure (map<string,map<CatomSim*,vector<int> > >)
	for (set<string>::const_iterator i = wpNames.begin(); i != wpNames.end(); i++) {
		//savedState[*i] = map<catomID,vector<int> >();
		for (hash_map<const unsigned long, CatomSim *, hash<const unsigned long>, equl>::iterator j = worldPtr->catomHash.begin();
		 			j != worldPtr->catomHash.end(); j++) {
			savedState[*i][(*j).second] = deque<float>();
		}
	}
}

void WPManager::addWatchpoint(string input) {
	Watchpoint *w = parseWP(input);
	w->id = wp_masters.size();
	wp_masters.push_back(w);
	cout << "DPRSim: WATCHPOINT ACTIVE, size:" << w->c_list->names.size() << ", variables:";
	//get list of variables needed
	set<string> names = w->watchedVariables();
	copy( names.begin(), names.end(), ostream_iterator<string>( cout, " " ) );
	cout << endl;
	//add new wp's variables to existing ones
	wpNames.insert(names.begin(),names.end());
	//determine temporal extent for each variable, and full-catom-state
	for (set<string>::const_iterator i = names.begin(); i != names.end(); i++) {
		int prevMin = minExtent.count(*i) ? minExtent[*i] : INT_MAX;
		minExtent[*i] = min(w->minExtent(*i),prevMin);
		int prevMax = maxExtent.count(*i) ? maxExtent[*i] : INT_MIN;
		maxExtent[*i] = max(w->maxExtent(*i),prevMax);
		if (maxExtent[*i] > max_temporal) max_temporal = maxExtent[*i];
	}
}

WPManager::~WPManager() {
	for (unsigned int i = 0; i < wp_masters.size(); i++)
		delete wp_masters[i];
}

void WPManager::step() {
	steps++;
	
	//prep work for actions
	for (unsigned int i = 0; i < wp_masters.size(); i++) {
		wp_masters[i]->matches = 0; //for Act_Count
		switch(wp_masters[i]->action) {
			case Act_Arrows:
				worldPtr->clearLines();
				break;
			default:
				break;
		}
	}
	
	//save state of each catom to statebuffers
	unsigned maxVSize = 1;
	for (set<string>::const_iterator i = wpNames.begin(); i != wpNames.end(); i++) {
		unsigned vSize = maxExtent[*i] - minExtent[*i] + 1;
		if (vSize > maxVSize) maxVSize = vSize;
		for (hash_map<const unsigned long, CatomSim *, hash<const unsigned long>, equl>::iterator j = worldPtr->catomHash.begin();
		 			j != worldPtr->catomHash.end(); j++) {
							//get value of i for catom j
							savedState[*i][(*j).second].push_front(getState((*j).second,(*i)));
							//trim vector to correct length if too long
							while (savedState[*i][(*j).second].size() > vSize) savedState[*i][(*j).second].pop_back();
		}
	}
	//MDR-TODO:store full state of every catom (if needed)
	if (max_temporal > 0) {
	
	}
	
	//if we're skipping execution steps, return here
	if (skip && (steps % skip)) return;
	
	//don't try to match if we don't have enough state
	if (steps-1 < maxVSize) return;
	
	//cout << "wp match begin" << endl;
	
	//build master neighbors hash
	map<CatomSim*,set <CatomSim *> > neighbors;
	for (hash_map<const unsigned long, CatomSim *, hash<const unsigned long>, equl>::iterator j = worldPtr->catomHash.begin();
	 	j != worldPtr->catomHash.end(); j++) {
			neighbors[j->second] = set<CatomSim*>();
			for (unsigned k = 0; k < NUM_FEATURES; k++) {
				catomID kthNeighbor = j->second->C.getNthNeighbor(k);
				if (kthNeighbor) {
					neighbors[j->second].insert(worldPtr->catomHash[kthNeighbor]);
				}
			}
		}
		
	set<Watchpoint*> activeMatchers;
	//instantiate and propagate values for 1 new matcher/catom
	for (hash_map<const unsigned long, CatomSim *, hash<const unsigned long>, equl>::iterator j = worldPtr->catomHash.begin();
	 			j != worldPtr->catomHash.end(); j++) {
					for (unsigned int i = 0; i < wp_masters.size(); i++) {
						Watchpoint *newWP = wp_masters[i]->clone();
						newWP->propagate(newWP->nextSlot(),(*j).second,this);
						activeMatchers.insert(newWP);
					}
	}
	
	while (activeMatchers.size()) {
		//cout << "wp match iter:" << activeMatchers.size() << endl;
		//for each matcher...
		set<Watchpoint*> tempSet;
		for (set<Watchpoint*>::const_iterator i = activeMatchers.begin(); i != activeMatchers.end(); i++) {
			//check for termination/success
			TriState sat = (*i)->isSatisfied();
			switch (sat) {
				case yes:
					//trigger matching actions here
					switch(wp_masters[(*i)->id]->action) {
						case Act_Halt:
							cout << "DPRSim:watchpoint triggered. Simulator will now halt." << endl;
							exit(0);
							break;
						case Act_Count:
							wp_masters[(*i)->id]->matches++;
							break;
						case Act_Arrows:
							this->addLinesForWatchpoint(*i);
							break;
						case Act_Color:
							this->addColorForWatchpoint(*i);
						default:
							break;
					}
					delete (*i);
					break;
				case no:
					delete (*i);
					break;
				case maybe:
					//if not terminated, get uniqued list of possible neighbors,spread,and propagate values
					if ((*i)->isFull()) 
						cout << "DPRSim:watchpoint full, but not verified. Uncool." << endl;
					else {
						set<CatomSim*> possible = possibleNeighbors(*i,neighbors);
						//cout << possible.size() << " new matchers" << endl;
						for (set<CatomSim*>::const_iterator j = possible.begin(); j != possible.end(); j++) {
							Watchpoint *newWP = (*i)->clone();
							newWP->propagate(newWP->nextSlot(),(*j),this);
							tempSet.insert(newWP);
						}
					}
					delete (*i);
					break;
			}			
		}
		swap(tempSet,activeMatchers);	
	}
	
	//post-step actions
	for (unsigned int i = 0; i < wp_masters.size(); i++) {
		switch(wp_masters[i]->action) {
		case Act_Count:
			cout << "wp " << i  << " step end, " << wp_masters[i]->matches << " matches" << endl;
			break;
		default:
			break;
		}
	}
}

float WPManager::getState(CatomSim *c,string varname) {
  // Replace colons with periods
  string::size_type pos;
  while((pos = varname.find(':')) != string::npos) {
    varname.replace(pos, 1, ".");
  }
  
  if (varname == "id") {
    return c->C.getID();
  }
  else if (varname == "numNeighbors") {
    int numNeighbors = 0;
    for (unsigned k = 0; k < NUM_FEATURES; k++) {
      if (c->C.getNthNeighbor(k)) {
				numNeighbors++;
      }
    }
    return numNeighbors;
  }
  else if(historianPtr) {
    try {
      return historianPtr->getDoubleVariableForCatomAndTick(varname, c->C.getID(), worldPtr->current_time);
    }
    catch (...) {
      // Don't do anything, just fall through
    }
  }
  
  cout << "no such variable:" << varname << endl;
  return 0;
}

float WPManager::lookupSavedState(CatomSim *c,string varname,int offset) {
	return savedState[varname][c][max_temporal - offset];
}

set<CatomSim*> WPManager::possibleNeighbors(Watchpoint*wp,map<CatomSim*,set <CatomSim *> > &n) {
	//get set of all used catom's neighbors from wp
	set<CatomSim *>candidates;
	for (unsigned i = 0; i < wp->c_list->names.size(); i++) {
		if (wp->c_list->names[i].second) {
			set <CatomSim *> &nSet = n[wp->c_list->names[i].second];
			candidates.insert(nSet.begin(),nSet.end());
		}
	}
	//remove the catoms already in the wp
	for (unsigned i = 0; i < wp->c_list->names.size(); i++) {
		if (wp->c_list->names[i].second) {
			candidates.erase(wp->c_list->names[i].second);
		}
	}
	set<CatomSim*> passed;
	//try each candidate, and add those that passed to the set
	for (set<CatomSim *>::iterator j = candidates.begin();j != candidates.end(); j++) {
		if (wp->isValidCandidate(n,wp->c_list->names,*j,wp->nextSlot()))
			passed.insert(*j);
	}
	return passed;
}

void WPManager::addLinesForWatchpoint(Watchpoint *wp) {
//#ifdef __USE_DRAWSTUFF__
	int r = rand() % 255;
	int g = rand() % 255;
	int b = rand() % 255;
	catomID prevID = 0;
	catomID currID = 0;
	for (vector<pair<string,CatomSim*> >::iterator i = wp->c_list->names.begin();
	i != wp->c_list->names.end(); i++) {
		if (i->second) {
			prevID = currID;
			currID = i->second->C.getID();
			if (prevID && currID) {
				//cout << currID << " " << prevID << endl;
				worldPtr->addLine(prevID,currID,r,g,b);
			}
		}
	}
}
	
void WPManager::addColorForWatchpoint(Watchpoint *wp) {
	int r = rand() % 255;
	int g = rand() % 255;
	int b = rand() % 255;
	int a = rand() % 128 + 128;
	for (vector<pair<string,CatomSim*> >::iterator i = wp->c_list->names.begin();i != wp->c_list->names.end(); i++) {
		if (i->second) {
			CatomSim* currCatom = i->second;
			if (currCatom) currCatom->C.setColor(r,g,b,a);
		}
	}
}
