///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: bdr @ cs.cmu.edu                                                //
//           casey.j.helfrich @ intel.com                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


#ifndef VISMANAGER_H
#define VISMANAGER_H

#include <list>
#include <string>
#include <vector>

#include "DPRSim.hxx"
#include "Primitives.hxx"

#include "VisDataTransforms.hxx"

using namespace std;

class VisManager {
public:
  VisManager();
  ~VisManager();

protected:
  VisDataInput stdInput;
  VisDataOutput stdOutput;
public:
  VisDataInput* getStdInput() { return &stdInput;}
  VisDataOutput* getStdOutput() { return &stdOutput; }

  vector<DPRLine> getLines();

  list<string> getAvailableTransformNames();
  VisDataTransform* newTransformWithName(string transformName);

    // displayTick + accessors
protected:
  unsigned displayTick;
public:
  void setDisplayTick(unsigned _displayTick) { displayTick = _displayTick; }
  unsigned getDisplayTick() { return displayTick; }

  // displayCatom + accessors
protected:
  unsigned displayCatom;
public:
  void setDisplayCatom(unsigned _displayCatom) { displayCatom = _displayCatom; }
  unsigned getDisplayCatom() { return displayCatom; }
};

#endif
