///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: bdr @ cs.cmu.edu                                                //
//           casey.j.helfrich @ intel.com                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "VisManager.hxx"

#include "Historian.hxx"

using namespace std;

VisManager::VisManager() : 
  stdInput(this),
  stdOutput(this),
  displayTick(0),
  displayCatom(0)
{ }

VisManager::~VisManager() { }

list<string> VisManager::getAvailableTransformNames() {
  list<string> transformNames;

  transformNames.push_back("Constant double value");
  transformNames.push_back("Rainbow colors 0-6");

  return transformNames;
}

VisDataTransform* VisManager::newTransformWithName(string transformName) {
  if(transformName == "Constant double value")
    return new VisDataConstantDouble();
  else if(transformName == "Rainbow colors 0-6")
    return new VisDataRainbow();
  else if(transformName == "Comparison")
    return new VisDataCompare();
  else if(transformName == "Value selection")
    return new VisDataChoose();
  else
    return NULL;
}

vector<DPRLine> VisManager::getLines() {
  if(historianPtr)
    return historianPtr->getLinesForTick(displayTick);

  vector<DPRLine> temp;
  return temp;
}
