///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: bdr @ cs.cmu.edu                                                //
//           casey.j.helfrich @ intel.com                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef VISDATATRANSFORMS_H
#define VISDATATRANSFORMS_H

#include "VisDataTransform.hxx"

#include <string>

using namespace std;

class VisManager;


class VisDataInput : public VisDataTransform {
protected:
  VisManager* manager;
public:
  VisDataInput(VisManager* _manager) : manager(_manager) { }
  virtual list<string> getOutputNames();

public:
  virtual string getOutputString(string outputName);
  virtual double getOutputDouble(string outputName);
};

class VisDataOutput : public VisDataTransform {
protected:
  VisManager* manager;
public:
  VisDataOutput(VisManager* _manager) : manager(_manager) { }

public:
  virtual string getOutputString(string outputName);
  virtual double getOutputDouble(string outputName);
  virtual list<string> getInputNames();
  virtual string getDefaultInputString(string inputName);
  virtual double getDefaultInputDouble(string inputName);
};

class VisDataConstantDouble : public VisDataTransform {
public:
  VisDataConstantDouble();
  virtual list<string> getOutputNames();
  double getOutputDouble(string outputName);

protected:
  double constantValue;
public:
  void setValue(double num);
};

class VisDataRainbow : public VisDataTransform {
public:
  virtual list<string> getInputNames();
  virtual list<string> getOutputNames();
  double getOutputDouble(string outputName);
};

typedef enum {
  kOpEquals = 0,
  kOpNotEquals = 1,
  kOpLessThan = 2,
  kOpLessThanOrEqual = 3,
  kOpGreaterThan = 4,
  kOpGreaterThanOrEqual = 5
} VisDataCompareOp;

class VisDataCompare : public VisDataTransform {
public:
  virtual list<string> getInputNames();
  virtual list<string> getOutputNames();
  double getOutputDouble(string outputName);
};

class VisDataChoose : public VisDataTransform {
public:
  virtual list<string> getInputNames();
  virtual list<string> getOutputNames();
  double getOutputDouble(string outputName);
  string getOutputString(string outputName);
};

#endif
