///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: bdr @ cs.cmu.edu                                                //
//           casey.j.helfrich @ intel.com                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef VISDATATRANSFORM_H
#define VISDATATRANSFORM_H

#include <list>
#include <map>
#include <string>

using namespace std;

class VisDataTransform {
public:
  VisDataTransform();
  virtual ~VisDataTransform();

  // Output values
  virtual list<string> getOutputNames();  // advisory, for UI purposes; not enforced
  virtual string getOutputString(string outputName);
  virtual double getOutputDouble(string outputName);
  
  // Attachments
public:
  virtual list<string> getInputNames();  // advisory, for UI purposes; not enforced
  void attachInput(string inputName, VisDataTransform* source, string sourceOutputName);
  void detachAllInputs();
  void detachInput(string inputName);

  // Input calculation
protected:
  virtual string getInputString(string inputName);
  virtual double getInputDouble(string inputName);
  virtual string getDefaultInputString(string inputName);
  virtual double getDefaultInputDouble(string inputName);
private:
  map<string, string> defaultInputStrings;
  map<string, double> defaultInputDoubles;

private:
  // attachments: inputName => (source, sourceOutputName)
  map<string, pair<VisDataTransform*, string> > attachments;
};


// Helpful macros

#define GETOUTPUT(name, fn)			\
  if(outputName == name)			\
    return fn;

#endif
