///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: bdr @ cs.cmu.edu                                                //
//           casey.j.helfrich @ intel.com                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "VisDataTransform.hxx"

#include <iostream>

using namespace std;


// Constructor/destructor

VisDataTransform::VisDataTransform() {

}

VisDataTransform::~VisDataTransform() {

}


// Default outputs implementation

list<string> VisDataTransform::getOutputNames() {
  list<string> temp;
  return temp;
}

string VisDataTransform::getOutputString(string outputName) {
  cerr << "No such outlet: " << outputName << endl;
  throw 0;
}
double VisDataTransform::getOutputDouble(string outputName) {
  cerr << "No such outlet: " << outputName << endl;
  throw 0;
}


// Default inputs implementation

list<string> VisDataTransform::getInputNames() {
  list<string> temp;
  return temp;
}

string VisDataTransform::getInputString(string inputName) {
  map<string, pair<VisDataTransform*, string> >::iterator attachmentIter = attachments.find(inputName);
  if(attachmentIter != attachments.end()) {
    // There is an attachment for this name
    pair<VisDataTransform*, string> attachment = (*attachmentIter).second;
    try {
      return attachment.first->getOutputString(attachment.second);
    }
    catch(...) {
      // Let it fall through to default checking
    }
  }

  // Use the default value
  // If it throws, just pass it through, as we have nothing else to do :-/
  return getDefaultInputString(inputName);
}

double VisDataTransform::getInputDouble(string inputName) {
  map<string, pair<VisDataTransform*, string> >::iterator attachmentIter = attachments.find(inputName);
  if(attachmentIter != attachments.end()) {
    // There is an attachment for this name
    pair<VisDataTransform*, string> attachment = (*attachmentIter).second;
    try {
      return attachment.first->getOutputDouble(attachment.second);
    }
    catch(...) {
      // Let it fall through to default checking
    }
  }

  // Use the default value
  // If it throws, just pass it through, as we have nothing else to do :-/
  return getDefaultInputDouble(inputName);
}

string VisDataTransform::getDefaultInputString(string inputName) {
  map<string,string>::iterator defaultIter = defaultInputStrings.find(inputName);
  if(defaultIter != defaultInputStrings.end()) {
    return (*defaultIter).second;
  }

  // No answer?  Throw.
  cerr << "No attachment or default for input: " << inputName << endl;
  throw 0;
}
double VisDataTransform::getDefaultInputDouble(string inputName) {
  map<string,double>::iterator defaultIter = defaultInputDoubles.find(inputName);
  if(defaultIter != defaultInputDoubles.end()) {
    return (*defaultIter).second;
  }

  // No answer?  Throw.
  cerr << "No attachment or default for input: " << inputName << endl;
  throw 0;
}


// Attachments

void VisDataTransform::attachInput(string inputName, VisDataTransform* source, string sourceOutputName) {
  attachments[inputName] = make_pair(source, sourceOutputName);
}

void VisDataTransform::detachAllInputs() {
  attachments.clear();
}

void VisDataTransform::detachInput(string inputName) {
  attachments.erase(inputName);
}
