#ifndef _UTIL_HXX_
#define _UTIL_HXX_
void debugMsg(char* format, ...);
void debugMsg(int level, char* format, ...);
void die(char* format, ...);

# define Assert(e, m...)	((e) ? (void)0 : __myassert(__FILE__, __LINE__, #e , ## m))
void __myassert(char* file, int line, char* exp, char*format, ...);

// Setup timing info for tracking different parts of the simulator
#define CONFIG_X86_TSC 1
#define rdtscll(val) \
     __asm__ __volatile__("rdtsc" : "=A" (val))
// from #include <asm/timex.h>
typedef unsigned long long cycles_t;
static inline cycles_t get_cycles (void)
{
#ifndef CONFIG_X86_TSC
  return 0;
#else
  unsigned long long ret;
  rdtscll(ret);
  return ret;
#endif
}

static inline double interpolate( double x1, double y1, double x2, double y2, double x ) {
  return y1 + (y2-y1)*(x-x1)/(x2-x1);
}

#endif

