///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>
#include <stdarg.h>
#include "Util.hxx"
#include "CatomWorld.hxx"
#include "DPRSim.hxx"
#include "CatomSim.hxx"

void
__myassert(char* file, int line, char* expr, char* format, ...) {
  return;
  char buffer[1024];
  char cbuff[32];
  va_list ap;
  va_start(ap,format);

  if (thisCatom() != 0) 
    sprintf(cbuff, "\n**** ASSERT FAILURE ****\nCatom %d: ", thisCatom()->getID());
  else
    strcpy(cbuff, "\n**** ASSERT FAILURE ****\n");

  sprintf(buffer, "%sassertion \"%s\" failed: file \"%s\", line %d %s\n", 
	  cbuff,
	  expr, file, line,
	  format);

  vfprintf(stderr, buffer, ap);

  simPause(true);
  sleep(10);
  exit(-1);
}

static void vDebugMsg(char* format, va_list ap)
{
  return;
}

int currentDebugLevel = 1;

void debugMsg(int level, char* format, ...) {
  if (level > currentDebugLevel) return;
  va_list ap;
  va_start(ap,format);
  vDebugMsg(format, ap);
  va_end(ap);
}

int printing = 1;

void debugMsg(char* format, ...) {
  if (!printing) return;
  va_list ap;
  va_start(ap,format);
  vDebugMsg(format, ap);
  va_end(ap);
}

void die(char* format, ...) {
  va_list ap;
  va_start(ap,format);
  char buffer[1024];
  vsprintf(buffer, format, ap);
  fprintf(stderr, "Fatal Error: %s\n", buffer);
  va_end(ap);
  exit(-1);
}



#if 0
//Functions for Catom message passthrough
Point3D calcOffsetFromFeatureCubic(featureID origin, featureID dest, Catom* c)
{
  Point3D oloc = c->getLocation(origin);
  Point3D dloc = c->getLocation(dest);
  
  Point3D offset = dloc-oloc;
  debugMsg("OffsetFromFeature: %d -> %d => %s", origin, dest, offset.toString());
  return offset;
}


featureID calcFeatureFromOffsetCubic(featureID recieved, RelPoint3D offset, Catom* c)
{
  Point3D rloc = c->getLocation(recieved);
  //  cout<<"recieved at "<<recieved<<" at "<<rloc.getX()<<" "<<rloc.getY()<<" "<<rloc.getZ()<<endl;
  Point3D result = -rloc + offset;
  //  cout<<"resultant vector = "<<result.getX()<<" "<<result.getY()<<" "<<result.getZ()<<endl;
  featureID nf = c->getNearestFeature(result+c -> getLocation());
  debugMsg("FeatureFromOffset: %d -> %s => %d", recieved, offset.toString(), nf);
  return nf;
}
#endif

