///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __STATSMANAGER_H
#define __STATSMANAGER_H

#include <map>
#include <set>
#include <string>
#include <vector>

#include "Primitives.hxx"

using namespace std;

// stats flags for standard logged values
#define STATS_MEAN  (1 << 0)
#define STATS_SUM   (1 << 1)
#define STATS_COUNT (1 << 2)
#define STATS_DIST  (1 << 8)

// stats flags for counters
#define STATS_VALUE (1 << 10)

class StatsManager {
public:
  StatsManager();
  ~StatsManager();

  void setEnabledStats(string enabledStatsList); // format: foo,bar,baz

  void log(string identifier, double data, string origin);
  void log(string identifier, double data, catomID cid);

  double counterInc(string identifier, string origin, double delta=1.0);
  double counterInc(string identifier, catomID origin, double delta=1.0);
  double counterDec(string identifier, string origin, double delta=1.0);
  double counterDec(string identifier, catomID origin, double delta=1.0);
  double getCounter(string identifier);

  string getStatsString(string identifier, unsigned flags);
  string createDistributionString(vector<double> values);
  void setCompletionStats(string identifier, unsigned flags);

protected:
  set<string> enabledStats;
  
  map<string, FILE*> files;          // string (identifier) => FILE* (log data file)
  FILE* fileForIdentifier(string identifier);     // opens the file, if necessary

  map<string, vector<double> > valueHistory; // string (identifier) => vector<double> (previous values)
  map<string, double> counters;              // string (identifier) => double (counter value)

  map<string, unsigned> completionStats;     // string (identifier) => unsigned (stats to dump on completion)
};

#endif
