///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __NETWORK_H
#define __NETWORK_H

#include <queue>
#include <vector>
#include <string>

#include "GlobalConstants.hxx"
#include "Primitives.hxx"

class Catom;
class Feature;
class FeatureMap;

extern simtime pref_fastStartEndTime;

using namespace std;

typedef string MailboxID;

typedef enum {
  MSGINTENT=0,
  MSGHEADER=1,
  MSGPAYLOAD=2,
} MessagePhase;
#define NUMMSGPHASES 3

class Message {
private:
  
public:
  Message(MailboxID);
  Message(MailboxID boxID, unsigned long long msgID);
  virtual ~Message();

  unsigned long long messageID;

  MailboxID mailboxID;
  featureID arrivalContact;

  virtual Message* clone() = 0;

  virtual unsigned long long headerSize()  { return sizeof(short); } // assume mailboxID is encoded as a short
  virtual unsigned long long payloadSize() { return sizeof(messageID) + sizeof(arrivalContact); }

  virtual string logString() { return ""; }
};

//////////////////////////////////////////////////////////////////////////
// Network interface
//
// Processes messages flowing through a contact or wireless adaptor
// 
// ***IMPORTANT: This class needs to be locked for concurrent access***

class NetworkAdapter {
private:
  pthread_mutex_t objectMutex;
  void lock();
  void unlock();
  
  unsigned long long remainingBandwidth;
  queue<Message*> *messageQueueOut;

  Message* currentMessage;
  unsigned long currentMessageHeaderBytesRemaining;
  unsigned long currentMessagePayloadBytesRemaining;
  bool busy() { return (currentMessage != NULL); }

  catomID hostCatom;
  featureID hostFeature;
  
public:
  NetworkAdapter(catomID CID, featureID FID);
  ~NetworkAdapter();
  
  // adds the appropriate amount of bandwidth for a new tick, then
  // processes any outstanding messages that it can
  void newTick(); 
  
  // called when a message arrives at a catom
  // inserts it into the mailbox for that type of message
  void messageIntentArrived(Message* msg);
  void messageHeadersArrived(Message* msg);
  void messagePayloadArrived(Message* msg);
  
  // Send message m; asynchronous send
  // Returns false if there's no catom at the other end right now
  // Send may still fail later even if it returns true now!
  bool sendMessage(Message* m);
  
  void workOnCurrentMessage();
  void sendMessages();
  
  //unsigned long stats_msgsSent;
  //unsigned long stats_msgsRcvd;
};

#endif    /* __NETWORK_H */
