///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: bdr @ cs.cmu.edu                                                //
//           casey.j.helfrich @ intel.com                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __HISTORIAN_HXX
#define __HISTORIAN_HXX

#include <list>
#include <map>
#include <sqlite3.h>
#include <string>
#include <vector>

#include "Primitives.hxx"

using namespace std;

class CatomSim;


typedef enum {
  dprdebug_ivar_type,
  dprdebug_class_type,
  dprdebug_classinfo_type
} memItemType;

class Historian {
  // Construction/destruction
public:
  Historian(string _dbPath, string _debuggingEnabled,  bool _overwrite=true);
  ~Historian();

  // DB support
protected:
  string dbPath;
  sqlite3* db;
  sqlite3_stmt* newSignpost_stmt;
  sqlite3_stmt* newEvent_stmt;
  sqlite3_stmt* findVariableVal_stmt;
  sqlite3_stmt* findVariableVal2_stmt;
  sqlite3_stmt* newValue_stmt;
  sqlite3_stmt* newLine_stmt;
  sqlite3_stmt* newCatom_stmt;
  sqlite3_stmt* findCatomWorldState_stmt;
  sqlite3_stmt* findCatomIDs_stmt;
  sqlite3_stmt* findLinesForTick_stmt;
  void maybeNewTxn();
  void newTxn();

  // World state tracking
public:
  void saveWorldStateForTick(long tick);
  string getWorldStateStringForCatomAndTick(string key, unsigned long catom, long tick);
  double getWorldStateDoubleForCatomAndTick(string key, unsigned long catom, long tick);
  vector<DPRLine> getLinesForTick(long tick);
  vector<catomID> getWorldStateCatomIDs();
protected:
  void saveLineForTick(DPRLine line, long tick);
  void saveCatomForTick(CatomSim* sim, long tick);
  bool loadWorldStateForCatomAndTick(unsigned long catom, long tick);
  void decachePendingStatements();
  unsigned long cachedWorldStateCatom;
  long cachedWorldStateTick;

  // Debugging support
public:
  string getStringVariableForCatomAndTick(string name, unsigned long catom, long tick);
  double getDoubleVariableForCatomAndTick(string name, unsigned long catom, long tick);
  double getDoubleVariableForCatomCodeModuleAndTick(string name, unsigned long catom, string codeModule, long tick);
  void addSignpost(string name, string file, uint32_t line, string function);
  void addEvent(string name, void* object, uint64_t value, uint8_t operation);
  uint64_t addValue(uint64_t value,  string type, uint64_t derived1, uint64_t derived2);
  void insertMemoryItem(void*,memItemType);
  void removeMemoryItem(void*);
  pair<void*,void*> findOwnerOf(void*);
protected:
  bool debuggingEnabled;
  uint64_t currentSignpostNum;
  uint64_t currentEventNum;
  uint64_t currentValueNum;
  map<void*,memItemType> memoryLocations;
};


#endif
