///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "FeatureMap.hxx"
#include "CatomWorld.hxx"
#include "DPRSim.hxx"

////////////////////////////////////////////////////////////////////////////
// Feature Methods

/* This is the old code; new code in .hxx file
Feature* Feature::getRemoteFeature() {
  
  if DPR_FEATUREMAP_DEBUG
    cout << "issuing getRemoteFeature(" << FID << ") for Catom (" 
	 << hostCatomID << ")" << endl;
  
  if(FID > NUM_FEATURES+1) {
    if DPR_FEATUREMAP_DEBUG
      cout << "Invalid FID!" << endl;
    return NULL;
  }
  
  catomID neighborCatom = worldPtr->catomHash[hostCatomID]->C.getNeighbor(FID);
  
  if (neighborCatom == 0) return NULL;
  
  //return &(worldPtr->catomHash[neighborCatom]->C.getFeatureMap()[NUM_FEATURES - FID + 1]);

  featureID nfid = worldPtr->catomHash[neighborCatom]->C.getFeatureTouching( hostCatomID );

  if ( nfid==0 ) return NULL;

  return &(worldPtr->catomHash[neighborCatom]->C.getFeatureMap()[nfid]);
}

*/


Point3D *Feature::locations = 0;
vector<Point3D> *Feature::faces = 0;



//Feature::Feature(catomID hostCatom, featureID F, Point3D loc) :
//  hostCatomID(hostCatom), FID(F), location(loc), NA(hostCatom, F)
Feature::Feature(catomID hostCatom, featureID F) :
  hostCatomID(hostCatom), FID(F), NA(hostCatom, F)
{

}

Feature::~Feature() {

}


static void setup_feature_map( string name, Point3D **centers, vector<Point3D> **faces, unsigned int *num_features, unsigned int *num_neighbors ) {

  if ( name=="square" ) name = "2D 4";
  if ( name=="hex" ) name = "2D 6";
  if ( name=="2Dhex+Z" ) name = "2D+Z 6";
  if ( name=="3D 6" ) name = "cube";
  if ( name=="3D 12" ) name = "fcc";
  if ( name=="3D 26" ) name = "vfs geo fcc";
  if ( name=="3D 50" ) name = "vfs geo geo cube";
  if ( name=="3D 98" ) name = "vfs geo geo fcc";
  if ( name.substr(0, 4) == "geo " ) {
    // perform geodesic tesselation of faces of given feature map
    Point3D *tmp_cent;
    vector<Point3D> *tmp_faces;
    unsigned int tmp_nf, tmp_nn;
    setup_feature_map( name.substr(4), &tmp_cent, &tmp_faces, &tmp_nf, &tmp_nn );
    delete[] ( tmp_cent );
    unsigned int i, n;
    for (i=1, n=0; i<=tmp_nf; i++) {
	unsigned int tmp = tmp_faces[i].size();
	n += (tmp>3)?tmp:4;
    }
    *num_features = n;
    *num_neighbors = 12;
    *centers = new Point3D[n+1];
    *faces = new vector<Point3D>[n+1];
    cerr << "FACES: " << n << "\n";
    for (i=1, n=1; i<=tmp_nf; i++) {
	if (tmp_faces[i].size()==3) {
	  Point3D a = tmp_faces[i][0].unit();
	  Point3D b = tmp_faces[i][1].unit();
	  Point3D c = tmp_faces[i][2].unit();
	  Point3D ab = (a+b).unit();
	  Point3D ac = (a+c).unit();
	  Point3D bc = (b+c).unit();
	  (*faces)[n].push_back(a); (*faces)[n].push_back(ab); (*faces)[n].push_back(ac);
	  (*centers)[n] = (a+ab+ac)/3; n++;
	  (*faces)[n].push_back(b); (*faces)[n].push_back(bc); (*faces)[n].push_back(ab);
	  (*centers)[n] = (b+bc+ab)/3; n++;
	  (*faces)[n].push_back(c); (*faces)[n].push_back(ac); (*faces)[n].push_back(bc);
	  (*centers)[n] = (c+ac+bc)/3; n++;
	  (*faces)[n].push_back(ab); (*faces)[n].push_back(bc); (*faces)[n].push_back(ac);
	  (*centers)[n] = (ab+bc+ac)/3; n++;
	} else {
	  vector<Point3D>::const_iterator it;
	  Point3D ctr, a, b;
	  for (it=tmp_faces[i].begin(); it!=tmp_faces[i].end(); it++) { a=*it; ctr+=a; }
	  ctr = ctr.unit();
	  a = a.unit();
	  for (it=tmp_faces[i].begin(); it!=tmp_faces[i].end(); it++) {
	    b = it->unit();
	    (*faces)[n].push_back(a); (*faces)[n].push_back(b); (*faces)[n].push_back(ctr);
	    (*centers)[n] = (a+b+ctr)/3; n++;
	    a = b;
	  }
	}
    }
    delete[] ( tmp_faces );
  }
  else if ( name.substr(0, 4) == "vfs " ) {
    // get vertices of faces as centers
    Point3D *tmp_cent;
    vector<Point3D> *tmp_faces;
    unsigned int tmp_nf, tmp_nn;
    setup_feature_map( name.substr(4), &tmp_cent, &tmp_faces, &tmp_nf, &tmp_nn );
    vector<Point3D> newcents;
    unsigned int i;
    for (i=1; i<=tmp_nf; i++) {
	vector<Point3D>::const_iterator it;
	for (it=tmp_faces[i].begin(); it != tmp_faces[i].end(); it++) {
	  vector<Point3D>::const_iterator it2;
	  for (it2=newcents.begin(); it2!=newcents.end() && *it2!=*it; it2++);
	  if (it2==newcents.end()) newcents.push_back(*it);
	}
    }
    delete[] (tmp_faces);
    delete[] (tmp_cent);
    unsigned int n = newcents.size();
    *num_features = n;
    *num_neighbors = 12;
    *centers = new Point3D[n+1];
    *faces = new vector<Point3D>[n+1];
    cerr << "FACES: " << n << "\n";
    vector<Point3D>::const_iterator it = newcents.begin();
    for (i=1; i<=n; i++, it++) {
	(*centers)[i] = it->unit();
	cerr << "FACE: " << i << " " << (*centers)[i].getX() << " " << (*centers)[i].getY() << " " << (*centers)[i].getZ() << endl;
    }
  }
  else if ( name=="tetra" ) {
    Point3D a( 1, 1, 1);
    Point3D b(-1,-1, 1);
    Point3D c(-1, 1,-1);
    Point3D d( 1,-1,-1);
    double l = 1.0/(a+b+c).norm();
    *num_features = 4;
    *num_neighbors = 4;
    *centers = new Point3D[5];
    *faces = new vector<Point3D>[5];
    (*centers)[1] = l*(a+b+c);
	(*faces)[1].push_back( 3*l*a );
	(*faces)[1].push_back( 3*l*b );
	(*faces)[1].push_back( 3*l*c );
    (*centers)[2] = l*(a+b+d);
	(*faces)[2].push_back( 3*l*a );
	(*faces)[2].push_back( 3*l*b );
	(*faces)[2].push_back( 3*l*d );
    (*centers)[3] = l*(a+d+c);
	(*faces)[3].push_back( 3*l*a );
	(*faces)[3].push_back( 3*l*d );
	(*faces)[3].push_back( 3*l*c );
    (*centers)[4] = l*(d+b+c);
	(*faces)[4].push_back( 3*l*d );
	(*faces)[4].push_back( 3*l*b );
	(*faces)[4].push_back( 3*l*c );
  }
  else if ( name == "oct" ) {
    int x,y,z,i;
    double s3 = sqrt(3.0);
    *num_features = 8;
    *num_neighbors = 8;
    *centers = new Point3D[9];
    *faces = new vector<Point3D>[9];
    i = 1;
    for ( x=-1; x<2; x+=2 ) {
      for ( y=-1; y<2; y+=2 ) {
	for( z=-1; z<2; z+=2 ) {
	  (*centers)[i] = Point3D(x,y,z)/s3;
	  (*faces)[i].push_back( s3*Point3D(x,0,0) );
	  (*faces)[i].push_back( s3*Point3D(0,y,0) );
	  (*faces)[i].push_back( s3*Point3D(0,0,z) );
	  i++;
	}
      }
    }
  }
  else if ( name=="fcc" ) {
    // features for face-centered cubic packing, aka cubic close packing
    // faceted shape is rhombic dodecahedron
    *num_features = 12;
    *num_neighbors = 12;
    *centers = new Point3D[13];
    *faces = new vector<Point3D>[13];
    (*centers)[1] = 0.70710678*Point3D(-1,0,-1);
      (*faces)[1].push_back( 0.70710678*Point3D( 0, 0,-2) );
      (*faces)[1].push_back( 0.70710678*Point3D(-1,-1,-1) );
      (*faces)[1].push_back( 0.70710678*Point3D(-2, 0, 0) );
      (*faces)[1].push_back( 0.70710678*Point3D(-1, 1,-1) );
    (*centers)[2] = 0.70710678*Point3D(0,-1,-1);
      (*faces)[2].push_back( 0.70710678*Point3D( 0, 0,-2) );
      (*faces)[2].push_back( 0.70710678*Point3D(-1,-1,-1) );
      (*faces)[2].push_back( 0.70710678*Point3D( 0,-2, 0) );
      (*faces)[2].push_back( 0.70710678*Point3D( 1,-1,-1) );
    (*centers)[3] = 0.70710678*Point3D(1,0,-1);
      (*faces)[3].push_back( 0.70710678*Point3D( 0, 0,-2) );
      (*faces)[3].push_back( 0.70710678*Point3D( 1,-1,-1) );
      (*faces)[3].push_back( 0.70710678*Point3D( 2, 0, 0) );
      (*faces)[3].push_back( 0.70710678*Point3D( 1, 1,-1) );
    (*centers)[4] = 0.70710678*Point3D(0,1,-1);
      (*faces)[4].push_back( 0.70710678*Point3D( 0, 0,-2) );
      (*faces)[4].push_back( 0.70710678*Point3D( 1, 1,-1) );
      (*faces)[4].push_back( 0.70710678*Point3D( 0, 2, 0) );
      (*faces)[4].push_back( 0.70710678*Point3D(-1, 1,-1) );
    (*centers)[5] = 0.70710678*Point3D(-1,-1,0);
      (*faces)[5].push_back( 0.70710678*Point3D(-2, 0, 0) );
      (*faces)[5].push_back( 0.70710678*Point3D(-1,-1,-1) );
      (*faces)[5].push_back( 0.70710678*Point3D( 0,-2, 0) );
      (*faces)[5].push_back( 0.70710678*Point3D(-1,-1, 1) );
    (*centers)[6] = 0.70710678*Point3D(-1,1,0);
      (*faces)[6].push_back( 0.70710678*Point3D(-2, 0, 0) );
      (*faces)[6].push_back( 0.70710678*Point3D(-1, 1,-1) );
      (*faces)[6].push_back( 0.70710678*Point3D( 0, 2, 0) );
      (*faces)[6].push_back( 0.70710678*Point3D(-1, 1, 1) );
    (*centers)[7] = 0.70710678*Point3D(1,1,0);
      (*faces)[7].push_back( 0.70710678*Point3D( 2, 0, 0) );
      (*faces)[7].push_back( 0.70710678*Point3D( 1, 1,-1) );
      (*faces)[7].push_back( 0.70710678*Point3D( 0, 2, 0) );
      (*faces)[7].push_back( 0.70710678*Point3D( 1, 1, 1) );
    (*centers)[8] = 0.70710678*Point3D(1,-1,0);
      (*faces)[8].push_back( 0.70710678*Point3D( 2, 0, 0) );
      (*faces)[8].push_back( 0.70710678*Point3D( 1,-1,-1) );
      (*faces)[8].push_back( 0.70710678*Point3D( 0,-2, 0) );
      (*faces)[8].push_back( 0.70710678*Point3D( 1,-1, 1) );
    (*centers)[9] = 0.70710678*Point3D(-1,0,1);
      (*faces)[9].push_back( 0.70710678*Point3D( 0, 0, 2) );
      (*faces)[9].push_back( 0.70710678*Point3D(-1,-1, 1) );
      (*faces)[9].push_back( 0.70710678*Point3D(-2, 0, 0) );
      (*faces)[9].push_back( 0.70710678*Point3D(-1, 1, 1) );
    (*centers)[10] = 0.70710678*Point3D(0,-1,1);
      (*faces)[10].push_back( 0.70710678*Point3D( 0, 0, 2) );
      (*faces)[10].push_back( 0.70710678*Point3D(-1,-1, 1) );
      (*faces)[10].push_back( 0.70710678*Point3D( 0,-2, 0) );
      (*faces)[10].push_back( 0.70710678*Point3D( 1,-1, 1) );
    (*centers)[11] = 0.70710678*Point3D(1,0,1);
      (*faces)[11].push_back( 0.70710678*Point3D( 0, 0, 2) );
      (*faces)[11].push_back( 0.70710678*Point3D( 1,-1, 1) );
      (*faces)[11].push_back( 0.70710678*Point3D( 2, 0, 0) );
      (*faces)[11].push_back( 0.70710678*Point3D( 1, 1, 1) );
    (*centers)[12] = 0.70710678*Point3D(0,1,1);
      (*faces)[12].push_back( 0.70710678*Point3D( 0, 0, 2) );
      (*faces)[12].push_back( 0.70710678*Point3D( 1, 1, 1) );
      (*faces)[12].push_back( 0.70710678*Point3D( 0, 2, 0) );
      (*faces)[12].push_back( 0.70710678*Point3D(-1, 1, 1) );
  }
  else if ( name=="hcp" ) {
    *num_features = 12;
    *num_neighbors = 12;
  }
  else if ( name.find("xc_") == 0 &&
	    name[3]>='1' && name[3]<='9' &&
	    name.length()==4 ) {
    unsigned int n = 1;
    int k = name.c_str()[3] - '1' + 1;
    int x,y,z;
    *num_features = (k+1)*(k+1)*(k+1) - (k-1)*(k-1)*(k-1);
    *num_neighbors = 12;
    *centers = new Point3D[*num_features+1];
    for ( x=-k; x<=k; x+=2 ) {
      for ( y=-k; y<=k; y+=2 ) {
        for ( z=-k; z<=k; z+=2 ) {
	  if ( abs(x)!=k && abs(y)!=k && abs(z)!=k ) continue;
	  Point3D tmp = Point3D( x,y,z );
	  tmp /= tmp.norm();
	  (*centers)[n] = tmp;
	  n++;
	}
      }
    }
  }
/*  else if ( name=="2Dhex+Z" ) {
    *num_features = 8;
    *num_neighbors = 8;
    *centers = new Point3D[9];
    *faces = new vector<Point3D>[9];

    // planar 2D features (stolen from below)
    double theta = 2*M_PI/ 6;
    double frad = 1.0 / cos( theta/2.0 );
    unsigned int n;
    for ( n=1; n<=6; n++ ) {
      // Location of the feature
      (*centers)[n] = Point3D( 1, 0, theta*((double)n-1), 1 );

      // Forward edge of face
      Point3D tmp = Point3D( frad, 0, theta*((double)n-1.5), 1);
      (*faces)[n].push_back( tmp+Point3D(0,0,1) );
      (*faces)[n].push_back( tmp+Point3D(0,0,-1) );
      // Points for top and bottom faces
      (*faces)[7].push_back( tmp+Point3D(0,0,1) );
      (*faces)[8].push_back( tmp+Point3D(0,0,-1) );
      // Back edge of face
      tmp = Point3D( frad, 0, theta*((double)n-0.5), 1);
      (*faces)[n].push_back( tmp+Point3D(0,0,-1) );
      (*faces)[n].push_back( tmp+Point3D(0,0,1) );
    }

    // Vertical features
    (*centers)[7] = Point3D( 0, 0,  1 );
    (*centers)[8] = Point3D( 0, 0, -1 );
  }*/
  else if ( ( name.find("2D ") == 0 && name.length() > 3 ) 
		|| ( name.find("2D+Z ") == 0 && name.length() > 5 ) ){
    *num_features = strtol( name.substr( name.find(" ")+1 ).c_str(), 0, 0 );
    if (*num_features<3) *num_features=3;
    *num_neighbors = 6;
    *centers = new Point3D[*num_features+3];
    *faces = new vector<Point3D>[*num_features+3];
    double theta = 2*M_PI/ (double)*num_features;
    double frad = 1.0 / cos( theta/2.0 );
    unsigned int n;
    for ( n=1; n<=*num_features; n++ ) {
      // Location of the feature
      (*centers)[n] = Point3D( 1, 0, theta*((double)n-1), 1 );

      // Forward edge of face
      Point3D tmp = Point3D( frad, 0, theta*((double)n-1.5), 1);
      (*faces)[n].push_back( tmp+Point3D(0,0,1) );
      (*faces)[n].push_back( tmp+Point3D(0,0,-1) );
      // Points for top and bottom faces
      (*faces)[*num_features+1].push_back( tmp+Point3D(0,0,1) );
      (*faces)[*num_features+2].push_back( tmp+Point3D(0,0,-1) );
      // Back edge of face
      tmp = Point3D( frad, 0, theta*((double)n-0.5), 1);
      (*faces)[n].push_back( tmp+Point3D(0,0,-1) );
      (*faces)[n].push_back( tmp+Point3D(0,0,1) );
    }
    if ( name.substr(2,2)=="+Z" ) {
      // Vertical features
      (*centers)[*num_features+1] = Point3D( 0, 0,  1 );
      (*centers)[*num_features+2] = Point3D( 0, 0, -1 );
      // fix up num neighbors, num features
      *num_neighbors = 8;
      *num_features += 2;
    }
  }
  else {  // cube
    *num_features = 6;
    *num_neighbors = 12;
    *centers = new Point3D[7];
    *faces = new vector<Point3D>[7];
    (*centers)[1] = Point3D(0,0,1); 
      (*faces)[1].push_back(Point3D(-1,-1,1));
      (*faces)[1].push_back(Point3D(-1,1,1)); 
      (*faces)[1].push_back(Point3D(1,1,1));
      (*faces)[1].push_back(Point3D(1,-1,1));
    (*centers)[2] = Point3D(1,0,0);
      (*faces)[2].push_back(Point3D(1,-1,-1)); 
      (*faces)[2].push_back(Point3D(1,-1,1)); 
      (*faces)[2].push_back(Point3D(1,1,1)); 
      (*faces)[2].push_back(Point3D(1,1,-1));
    (*centers)[3] = Point3D(0,1,0);
      (*faces)[3].push_back(Point3D(-1,1,-1)); 
      (*faces)[3].push_back(Point3D(-1,1,1)); 
      (*faces)[3].push_back(Point3D(1,1,1)); 
      (*faces)[3].push_back(Point3D(1,1,-1));
    (*centers)[4] = Point3D(0,-1,0);
      (*faces)[4].push_back(Point3D(-1,-1,-1)); 
      (*faces)[4].push_back(Point3D(-1,-1,1)); 
      (*faces)[4].push_back(Point3D(1,-1,1)); 
      (*faces)[4].push_back(Point3D(1,-1,-1));
    (*centers)[5] = Point3D(-1,0,0);
      (*faces)[5].push_back(Point3D(-1,-1,-1)); 
      (*faces)[5].push_back(Point3D(-1,-1,1)); 
      (*faces)[5].push_back(Point3D(-1,1,1)); 
      (*faces)[5].push_back(Point3D(-1,1,-1));
    (*centers)[6] = Point3D(0,0,-1);
      (*faces)[6].push_back(Point3D(-1,-1,-1)); 
      (*faces)[6].push_back(Point3D(-1,1,-1)); 
      (*faces)[6].push_back(Point3D(1,1,-1)); 
      (*faces)[6].push_back(Point3D(1,-1,-1));
  }
  
}


void get_lattice_info( string name, unsigned int *lattice_type, unsigned int *num_features, unsigned int *num_neighbors ) {
  if (Feature::locations) { delete [] Feature::locations; }
  if (Feature::faces) { delete [] Feature::faces; }
  setup_feature_map( name, &Feature::locations, &Feature::faces, num_features, num_neighbors );
}



void get_feature_map( unsigned int lattice_type, catomID i, Feature *map ) {
  // need to test and adjust locations if not faceted (but only once)
  static bool initialized = false;
  if (!initialized) {
    if ( worldPtr->use_faceted==false ) {
	unsigned int i;
	for (i=1; i<=NUM_FEATURES; i++) {
	  map->locations[i] = map->locations[i].unit();
	}
    }
    initialized = true;
  }
  // simply make n features
  unsigned int n;
  for ( n=1; n<=NUM_FEATURES; n++ ) {
    map[n] = Feature( i, n );
  }
}

