#ifndef __DPRSim_hxx__
#define __DPRSim_hxx__

#include <iostream>
#include "pstream.h"

using namespace std;

typedef struct {
    void (*preStart)();
    void (*threadStart)();
    void (*start)();
    void (*tick)();
    void (*end)();
    void (*getView)(float xyz[3], float hpr[3], void *rgb);
} SimCallback;

class CatomWorld;
extern CatomWorld *worldPtr;

class Historian;
extern Historian *historianPtr;

class VisManager;
extern VisManager *visManagerPtr;

class StatsManager;
extern StatsManager *statsMgrPtr;

extern redi::opstream msgTrace;

void selectCallback(float x, float y, float z, float dx, float dy, float dz);
void simStop();
extern "C" {
	void simPause(bool state);
	bool simGetPaused();
}
bool building();
void simAdvanceSteps(int n);

// Extern of Catom Function for non-Threaded execution
extern void *catomFunction(void *vargp);


#endif /* __DPRSim_hxx__ */
