#ifndef __DCOND_MANAGER__
#define __DCOND_MANAGER__

#include "DCondParse.hxx"
#include <limits.h>
#include <map>
#include <deque>
#include <vector>
#include <iostream>
#include <algorithm>

using namespace std;

//gets all used variable names in DCondition
class VarNamesVisitor: public Visitor {
	public:
		map<string,VarCode> names;
		virtual void visitDCondition(DCondition *o) {names.clear(); o->main_exp->accept(this); o->a_list->accept(this);}
		virtual void visitModuleVar(ModuleVar *o) {names[o->var] = o->code;}
		virtual void visitSetVar(SetVar *o) {names[o->var] = o->code;}
};

//inserts correct varCode into variable expressions
class VarCodeInsertionVisitor: public Visitor {
	public:
		ModuleWrapper *module;
		virtual void visitModuleVar(ModuleVar *o) {o->code = module->codeForVarname(o->var);}
		virtual void visitSetVar(SetVar *o) {o->code = module->codeForVarname(o->var);}
		virtual void visitSetVarAction(SetVarAction *o) {o->code = module->codeForVarname(o->varname); o->module->accept(this); o->value->accept(this);}
};

//gets min extent for a given varname
class MinExtentVisitor: public Visitor {
	public:
		int minVal;
		VarCode code;
		virtual void visitDCondition(DCondition *o) {minVal = INT_MAX; o->c_list->accept(this); o->main_exp->accept(this); o->a_list->accept(this);}
		virtual void visitModuleVar(ModuleVar *o);
		virtual void visitSetVar(SetVar *o);
};

//gets min extent for a given varname
class MaxExtentVisitor: public Visitor {
	public:
		int maxVal;
		VarCode code;
		virtual void visitDCondition(DCondition *o) {maxVal = INT_MIN; o->c_list->accept(this); o->main_exp->accept(this); o->a_list->accept(this);}
		virtual void visitModuleVar(ModuleVar *o);
		virtual void visitSetVar(SetVar *o);
};

//applies temporal shift
class TemporalShiftVisitor: public Visitor {
	virtual void visitModuleRef(ModuleRef *o) {o->temporalOffset++;}
	virtual void visitIdxModuleRef(IdxModuleRef *o) {o->temporalOffset++;}
};

class DCondManager {
	public:
		vector<DCondition*> masters;
		vector<DCondition*> actives;
		vector<DCondition*> rerouteds;
		vector<DCondition*> readyToAct;
		ModuleWrapper *localModule;
		unsigned long steps;
		map<string,VarCode> varNames; //variable names (over all conditions)
		int minTemporal; //max future temporal extent (over all conditions)
		map<VarCode,int> minExtent; //min extent for each variable (over all conditions)
		map<VarCode,int> maxExtent; //max extent for each variable (over all conditions)
		map<VarCode,deque<float> > savedRealState; //to access module's var foo (current value) savedState["foo"][0]
		map<VarCode,deque<set<float> > > savedSetState;
		
		DCondManager(ModuleWrapper *m);
		void tick();
		void messageReceived(DCMessage *msg, ModuleWrapper *source);
		void addCondition(DCondition *c);
	protected:
		bool isDuplicateMultihop(DCMessage* msg,ModuleWrapper *src);
		set<ModuleWrapper*> possibleDistantNeighbors(DCondition *c);
};

#endif
