#include "DCondManager.hxx"
#include <cmath>

#define BATCH_ACTIONS 0

class FillVariablesVisitor: public Visitor {
	public :
		DCondManager *manager;
		pair<string, int>module;
		bool adjacency_failed;
		virtual void visitDCondition(DCondition *o,DCondManager *m, pair<string,int> id) {
			manager = m, module = id;
			adjacency_failed=false;
			o->c_list->accept(this); o->main_exp->accept(this); o->a_list->accept(this);
			//expand adjacency matrix
			int newSize = o->adjacency.shape()[0] + 1;
			adj_array::extent_gen newExtent;
			o->adjacency.resize(newExtent[newSize][newSize]);
			o->adjacency[newSize-1][newSize-1] = true;
			if (newSize==1) return;
			//for each neighbor of the local module, add adjacency edges
			set<ModuleWrapper *> n = manager->localModule->neighbors();
			int seen_count=0;
			for (set<ModuleWrapper*>::const_iterator j = n.begin(); j != n.end(); j++) {
				int slotIdx = o->slotIdx(*j);
				//cout << "slot index of neighbor " << (*j)->id << " is " << slotIdx << endl;
				if (slotIdx != -1) {o->adjacency[newSize-1][slotIdx] = o->adjacency[slotIdx][newSize-1] = true; seen_count++; }
			}
			if (seen_count==0) {
				adjacency_failed=true;
				//cerr<<"OOPS! how come we have no neighbors? " << n.size() << "\n"; 
			};
		}
		virtual void visitModuleVar(ModuleVar *o) {
			o->mref->accept(this); //ensure that indexed references are resolved first
			if (o->mref->matchesModule(module.first,module.second)) {
				o->filled = true;
				if (o->mref->temporalOffset != IMM_OFFSET)
					o->value = manager->savedRealState[o->code][o->mref->temporalOffset + manager->minTemporal];
				else
					o->value = manager->localModule->getRealVar(o->code);
			}
		}
		virtual void visitSetVar(SetVar *o) {
			o->mref->accept(this); //ensure that indexed references are resolved first
			if (o->mref->matchesModule(module.first,module.second)) {
				o->filled = true;
				if (o->mref->temporalOffset != IMM_OFFSET)
					o->value = manager->savedSetState[o->code][o->mref->temporalOffset + manager->minTemporal];
				else
					o->value = manager->localModule->getSetVar(o->code);
			}
		}
		virtual void visitModuleDecl(ModuleDecl *o) {
			if ((o->name == module.first) && ((int) o->maxSize > module.second)) {
				o->modules.push_back(manager->localModule);
			}
		}
		virtual void visitMathExp(MathExp *o) {
			o->lval->accept(this); o->rval->accept(this);
			if (o->lval-> filled && o->rval->filled) {
				switch(o->op) {
					case plus_op:
						o->value = o->lval->value + o->rval->value;
						break;
					case minus_op:
						o->value = o->lval->value - o->rval->value;
						break;
					case times_op:
						o->value = o->lval->value * o->rval->value;
						break;
					case div_op:
						o->value = o->lval->value / o->rval->value;
						break;
					case mod_op:
						o->value = fmod(o->lval->value,o->rval->value);
						break;
				}
				o->filled = true;
			}
		}
		virtual void visitNeighborExp(NeighborExp *o) {
			o->lval->accept(this); o->rval->accept(this);
			if (o->lval->matchesModule(module.first,module.second)) o->lmodule = manager->localModule->id;
			if (o->rval->matchesModule(module.first,module.second)) o->rmodule = manager->localModule->id;
			//set satisfied member variable
			if ((manager->localModule->id == o->lmodule) && (o->rmodule != INVALID_ID)) {
				set<ModuleWrapper *>neighbors = manager->localModule->neighbors();
				o->satisfied = no;
				for (set<ModuleWrapper*>::iterator i = neighbors.begin(); i != neighbors.end(); i++) {
					if ((*i)->id == o->rmodule) { o->satisfied = yes; break; }
				}
			}
			else if ((manager->localModule->id == o->rmodule) && (o->lmodule != INVALID_ID)) {
				set<ModuleWrapper *>neighbors = manager->localModule->neighbors();
				o->satisfied = no;
				for (set<ModuleWrapper*>::iterator i = neighbors.begin(); i != neighbors.end(); i++) {
					if ((*i)->id == o->lmodule) { o->satisfied = yes; break; }
				}
			}
		}		
		virtual void visitSetBExp(SetBExp *o) {
			o->set->accept(this);
			if (o->set->filled) {
				if (o->op == "->empty?") {
					if (o->set->value.size() == 0) o->satisfied = yes;
					else o->satisfied = no;
				}
				else {
					cout << "Unknown operator:" << o->op << endl;
				}
			}
			else o->satisfied = maybe;
		}
		virtual void visitSetRExp(SetRExp *o) {
			o->set->accept(this);
			if (o->set->filled) {
				if (o->op == "->size") {
					o->value = o->set->value.size();
				}
				else if (o->op == "->any") {
					o->value = *(o->set->value.begin());
				}
				else if (o->op == "->random") {
					if (o->set->value.size() > 0) {
						unsigned idx = rand() % o->set->value.size();
						set<float>::iterator iter = o->set->value.begin();
						while (idx > 0) {
							iter++;
							idx--;
						}
						o->value = *(iter);
					}
					else {
						o->value = 0;
					}
				}
				else {
					cout << "Unknown operator:" << o->op << endl;
				}
				o->filled = true;
			}
		}
		virtual void visitSetSExp(SetSExp *o) {
			o->lval->accept(this); o->rval->accept(this);
			if (o->lval->filled && o->rval->filled) {
				if (o->op == "->union(") {
					o->value.clear();
					set_union(o->lval->value.begin(),o->lval->value.end(),
						o->rval->value.begin(),o->rval->value.end(),
						inserter(o->value,o->value.end()));
				}
				else if (o->op == "->intersect(") {
					o->value.clear();
					set_intersection(o->lval->value.begin(),o->lval->value.end(),
							o->rval->value.begin(),o->rval->value.end(),
							inserter(o->value,o->value.end()));
				}
				else {
					cout << "Unknown operator:" << o->op << endl;
				}
				o->filled = true;
			}
		}
		virtual void visitCountExp(CountExp *o) {
			for(unsigned i = 0; i < o->required.size(); i++) o->required[i]->accept(this);
			for(unsigned i = 0; i < o->optional.size(); i++) o->optional[i]->accept(this);
			int yesCount = 0;
			int maybeCount = 0;
			for(unsigned i = 0; i < o->required.size(); i++) {
				if (o->required[i]->isSatisfied(false) == maybe) maybeCount++; 
				if (o->required[i]->isSatisfied(false) == yes) yesCount++;
			}
			for(unsigned i = 0; i < o->optional.size(); i++) {
				if (o->optional[i]->isSatisfied(false) == yes) yesCount++;
			}
			o->value = yesCount;
			o->filled = (maybeCount == 0);
		}
};

class ImmediateVariablesVisitor: public FillVariablesVisitor { //derived class that only re-fills immediate variables
	public:
	virtual void visitDCondition(DCondition *o,DCondManager *m, pair<string,int> id) {
		manager = m, module = id;
		adjacency_failed=false;
		o->c_list->accept(this); o->main_exp->accept(this); o->a_list->accept(this);
	}
	virtual void visitModuleVar(ModuleVar *o) {
		o->mref->accept(this); //ensure that indexed references are resolved first
		if (o->mref->matchesModule(module.first,module.second)) {
			if (o->mref->temporalOffset == IMM_OFFSET) o->value = manager->localModule->getRealVar(o->code);
		}
	}
	virtual void visitSetVar(SetVar *o) {
		o->mref->accept(this); //ensure that indexed references are resolved first
		if (o->mref->matchesModule(module.first,module.second)) {
			if (o->mref->temporalOffset == IMM_OFFSET) o->value = manager->localModule->getSetVar(o->code);
		}
	}
	virtual void visitModuleDecl(ModuleDecl *o) {
		
	}	
};

void MinExtentVisitor::visitModuleVar(ModuleVar *o) { 
	if (code == o->code) {
		if (o->mref->temporalOffset != IMM_OFFSET) {
			if (o->mref->temporalOffset < minVal) minVal = o->mref->temporalOffset;
		}
		else {
			if (0 < minVal) minVal = 0;
		}
	}
}
			
void MinExtentVisitor::visitSetVar(SetVar *o){ 
	if (code == o->code) {
		if (o->mref->temporalOffset != IMM_OFFSET) {
			if (o->mref->temporalOffset < minVal) minVal = o->mref->temporalOffset;
		}
		else {
			if (0 < minVal) minVal = 0;
		}
	}
}

void MaxExtentVisitor::visitModuleVar(ModuleVar *o) { 
	if (code == o->code) {
		if (o->mref->temporalOffset != IMM_OFFSET) {
			if (o->mref->temporalOffset > maxVal) maxVal = o->mref->temporalOffset;
		}
		else {
			if (0 > maxVal) maxVal = 0;
		}
	}
}
			
void MaxExtentVisitor::visitSetVar(SetVar *o){ 
	if (code == o->code) {
		if (o->mref->temporalOffset != IMM_OFFSET) {
			if (o->mref->temporalOffset > maxVal) maxVal = o->mref->temporalOffset;
		}
		else {
			if (0 > maxVal) maxVal = 0;
		}
	}
}

DCondManager::DCondManager(ModuleWrapper *m) {
	localModule = m;
	minTemporal = 0;
	steps = 0;
}

void DCondManager::addCondition(DCondition *c) {
	masters.push_back(c);
	//insert variable codes from current wrapper
	VarCodeInsertionVisitor coder;
	coder.module = localModule;
	coder.visitDCondition(c);
	//determine watched variables and temporal extent for new condition
	VarNamesVisitor n;
	n.visitDCondition(c);
	map<string,VarCode>::iterator currName;
	int newMinTemporal = 0;
	//for each variable...
	for (currName = n.names.begin(); currName != n.names.end(); currName++) {
		bool newName = (varNames.find(currName->first) == varNames.end());
		varNames[currName->first] = currName->second; //add to list of watched variables
		
		VarCode currCode = currName->second;
		
		//get min & max temporal extent for each variable, and for entire condition
		//remember that future shifts are negative!
		MinExtentVisitor minExtentV;
		minExtentV.code = currCode;
		minExtentV.visitDCondition(c);
		if (newName) minExtent[currCode] = minExtentV.minVal;
		else minExtent[currCode] = (minExtentV.minVal < minExtent[currCode]) ? minExtentV.minVal : minExtent[currCode];
		
		MaxExtentVisitor maxExtentV;
		maxExtentV.code = currCode;
		maxExtentV.visitDCondition(c);
		if (newName) maxExtent[currCode] = maxExtentV.maxVal;
		else maxExtent[currCode] = (maxExtentV.maxVal > maxExtent[currCode]) ? maxExtentV.maxVal : maxExtent[currCode];
			
		if (-1 * minExtentV.minVal > newMinTemporal) newMinTemporal = -1 * minExtentV.minVal;
		
		//cout << (*currName) << " " << minExtent[*currName] << " " << maxExtent[*currName] << endl;
		
		//initialize state tracking structure (if needed)
		if ((currName->first)[0] == '$') {
			if(savedSetState.find(currCode) == savedSetState.end()) savedSetState[currCode] = deque<set<float> >();
		}
		else {
			if(savedRealState.find(currCode) == savedRealState.end()) savedRealState[currCode] = deque<float>();
		}
	}
	
	if (newMinTemporal > minTemporal) minTemporal = newMinTemporal;
}

void DCondManager::tick() {
	steps++;
	//save real and set state
	unsigned maxVSize = 1;
	for (map<string,VarCode>::const_iterator i = varNames.begin(); i != varNames.end(); i++) {
		unsigned vSize = maxExtent[i->second] - minExtent[i->second] + 1;
		if (vSize > maxVSize) maxVSize = vSize;
		if ((i->first)[0] == '$') {
			//get value of i for local module
			savedSetState[i->second].push_front(localModule->getSetVar(i->second));
			//trim vector to correct length if too long
			while (savedSetState[i->second].size() > vSize) savedSetState[i->second].pop_back();
		}
		else {
			//get value of i for local module
			savedRealState[i->second].push_front(localModule->getRealVar(i->second));
			//trim vector to correct length if too long
			while (savedRealState[i->second].size() > vSize) savedRealState[i->second].pop_back();
		}
	}
	
	//cout <<localModule->id << "'s step " << steps << " (min is " << maxVSize << ")" << endl;
	
	//don't try to match if we don't have enough state
	if (steps-1 < maxVSize) return;
	
	//clone master conditions, add to active set
	for (vector<DCondition*>::const_iterator i = masters.begin(); i != masters.end(); i++) {
		actives.push_back((*i)->clone());
	}
	
	FillVariablesVisitor filler;
	ImmediateVariablesVisitor immFiller;
	set<ModuleWrapper *>neighbors = localModule->neighbors();
	
	//for each active matcher...
	for (vector<DCondition*>::const_iterator i = actives.begin(); i != actives.end(); i++) {
		set<pair<string, int> >nextSlots = (*i)->nextSlots();
		//split active matcher for quantified kleene-* (if needed)
		for (set<pair<string, int> >::const_iterator j = nextSlots.begin(); j != nextSlots.end(); j++) {
			//cout << (*i)->fillCount() << ": next slot to fill " << (*j).first << (*j).second << endl; 
			DCondition *currActive = (*i)->clone();
			//if (localModule->id == 200) cout << "executing cond id " << currActive->id << endl;
			//fill next slot of active matcher
			filler.visitDCondition(currActive,this,*j);
			if (filler.adjacency_failed) {
				// failed
			}
			//test & spread active matcher
			else if (currActive->isSatisfied() == yes) {
				//dispatch for action execution
				//cout << "dispatch for action execution" << endl;
				pair<string,int> triggerLoc = currActive->a_list->triggerLoc();
				if (currActive->moduleForName(triggerLoc.first,triggerLoc.second)->id != localModule->id) { //reroute for action trigger
					DCMessage *msg = new DCMessage(currActive->clone(),true,
								true,currActive->moduleForName(triggerLoc.first,triggerLoc.second));
					msg->dest = currActive->moduleForName(triggerLoc.first,triggerLoc.second);
					localModule->send(msg,currActive->nextRoutingStep(localModule,msg->dest));
				}
				else { //execute on local module
					if (BATCH_ACTIONS)
						readyToAct.push_back(currActive->clone());	
					else {
						immFiller.visitDCondition(currActive,this,*j); //re-fill immediate values
						if (currActive->isSatisfied() == yes) {
							for (unsigned k = 0; k < currActive->a_list->actions.size(); k++) {
									currActive->a_list->actions[k]->trigger(localModule,this);
							}
						}
					}
				}
				
				//if we're not totally full, and we're matching all, continue propagating
				bool matchAll = false;
				if (!currActive->isFull() && matchAll) {
					//spread to local neighbors
					for (set<ModuleWrapper*>::const_iterator k = neighbors.begin(); k != neighbors.end(); k++) {
						if (currActive->slotIdx(*k) == -1) { //neighbor is not already in matcher
						//construct and send message here
							DCMessage *msg = new DCMessage(currActive->clone(),false,false,*k);
							localModule->send(msg,*k);
						}
					}
				}
			}
			else if (currActive->isSatisfied() == maybe) {
				if (currActive->isFull()) cout << "full, but still indeterminate" << endl;
				//spread to local neighbors
				for (set<ModuleWrapper*>::const_iterator k = neighbors.begin(); k != neighbors.end(); k++) {
					//cout << "spreading from " << localModule->id << " to " << (*k)->id << endl;
					if (currActive->slotIdx(*k) == -1) { //neighbor is not already in matcher
						//construct and send message here
						DCMessage *msg = new DCMessage(currActive->clone(),false,false,*k);
						localModule->send(msg,*k);
					}
				}
				//spread to remote neighbors
				if (currActive->slotIdx(localModule) > 0) {
					set<ModuleWrapper*>distantNeighbors = possibleDistantNeighbors(currActive);
					for (set<ModuleWrapper*>::const_iterator k = distantNeighbors.begin(); k != distantNeighbors.end(); k++) {
						//cout << "REMOTE SPREAD: " << endl;
						//PrintCondVisitor pcv;
						//pcv.visitDCondition(currActive);
						
						DCMessage *msg = new DCMessage(currActive->clone(),true,false,*k);
						localModule->send(msg,currActive->nextRoutingStep(localModule,msg->dest));
					}
				}
			}
			else { //failed, normally do nothing
				
			}
			delete currActive;
		}
		delete (*i);
	}
	actives.clear();
	
	//spread rerouted matchers to our 1-hop neighbors
	for (vector<DCondition*>::const_iterator i = rerouteds.begin(); i != rerouteds.end(); i++) {
		for (set<ModuleWrapper*>::const_iterator j = neighbors.begin(); j != neighbors.end(); j++) {
				if ((*i)->slotIdx(*j) == -1) { //neighbor is not already in matcher
					//construct and send message here
					DCMessage *msg = new DCMessage((*i)->clone(),false,false,*j);
					localModule->send(msg,*j);
				}
		}
		delete (*i);
	}
	rerouteds.clear();
	
	//execute actions if we're batching them
	for (vector<DCondition*>::const_iterator i = readyToAct.begin(); i != readyToAct.end(); i++) {
		immFiller.visitDCondition((*i),this,(*i)->slotName(localModule)); //re-fill immediate values
		if ((*i)->isSatisfied() == yes) {
			for (unsigned k = 0; k < (*i)->a_list->actions.size(); k++) {
				(*i)->a_list->actions[k]->trigger(localModule,this);
			}
		}
 		delete (*i);	
	}
	readyToAct.clear();
	
}

void DCondManager::messageReceived(DCMessage *msg, ModuleWrapper *source) {
	//cout << "msg received." << endl;
	//if desired, temporal shift matcher
	TemporalShiftVisitor ts;
	//ts.visitDCondition(msg->matcher);
	
	ImmediateVariablesVisitor immFiller;
	
	if (msg->isMultihop) { //multihop message
		if(localModule->id == msg->dest->id) {//are we the current destination?
			if (isDuplicateMultihop(msg,source) ) {//if the message is a duplicate, delete it
				delete msg->matcher;
			}
			else {
				if (msg->isAction) { //sent to us to trigger local actions
					//trigger actions
					if (BATCH_ACTIONS)
						readyToAct.push_back(msg->matcher);
					else {
						//re-fill immediate values
						immFiller.visitDCondition(msg->matcher,this,msg->matcher->slotName(localModule)); 
						if (msg->matcher->isSatisfied() == yes) {
							for (unsigned i = 0; i < msg->matcher->a_list->actions.size(); i++) {	
								msg->matcher->a_list->actions[i]->trigger(localModule,this); //trigger action
							}
						}
						delete msg->matcher;
					}
				}
				else {
					//queue to propagate to our 1-hop neighbors (don't fill state info again)
					rerouteds.push_back(msg->matcher);
				}
			}
		}
		else {
			//forward on to next hop
			localModule->send(msg,msg->matcher->nextRoutingStep(localModule,msg->dest));
			return;
		}
	}
	else {
		//add incoming matcher to local set (state info will be filled)
		actives.push_back(msg->matcher);
		//cout << "size of actives on " << localModule->id << " is " << actives.size() << endl;
	}
	delete msg;
  return;
}

//is the current catom the neighbor of two (or more) catoms in the wp?
//did the message not come from the highest slot numbered of those catoms?
//else false
bool DCondManager::isDuplicateMultihop(DCMessage* msg,ModuleWrapper *src) {
	int senderIdx = msg->matcher->slotIdx(src); //get slot index of sender
	//find max slot index of other neighbors (if any)
	int maxIdx = senderIdx;
	set<ModuleWrapper*> n = localModule->neighbors();
	for (set<ModuleWrapper*>::iterator i = n.begin();i != n.end(); i++) {
		if (msg->matcher->slotIdx(*i) > maxIdx) maxIdx = msg->matcher->slotIdx(*i);
	}
	if (maxIdx > senderIdx) return true; //message should properly come from max numbered neighbor
	return false;
}

//calculate distant neighbors
set<ModuleWrapper*> DCondManager::possibleDistantNeighbors(DCondition *c) {
	set<ModuleWrapper*>candidates;
	//if (linearOnly) return candidates; //never spawn any multihop messages

	//add every other module in condition to set 	
	for (unsigned i = 0; i < c->c_list->modules.size(); i++) 
		for (unsigned j = 0; j < c->c_list->modules[i]->modules.size(); j++){
		candidates.insert(c->c_list->modules[i]->modules[j]);
	}
	//remove this module
	candidates.erase(localModule);

	//if (!enableNeighborSelect) return candidates; //don't cull impossible remote neighbors
		
	set<ModuleWrapper*> passed;
	//TODO:try each candidate, and add those that passed to the set
/*	for (set<ModuleWrapper*>::iterator j = candidates.begin();j != candidates.end(); j++) {
		if (wp->isValidCandidate(worldPtr->catomHash[*j],wp->nextSlot()))
			passed.insert(*j);
	}
	return passed;*/
	return candidates;
}
