#ifndef __DCOND_TEST__
#define __DCOND_TEST__

#include "DCondParse.hxx"
#include "DCondManager.hxx"
#include <iostream>
#include <string>

using namespace std;

class PrintCondVisitor: public Visitor {
	public:
		unsigned indent;
		virtual void visitDCondition(DCondition *o) {
			cout << "DCondition(" << endl;
			indent = 1;
			for (unsigned i = 0; i < o->adjacency.shape()[0]; i++) {
				for (unsigned j = 0; j < o->adjacency.shape()[1]; j++) {
					cout << o->adjacency[i][j] << " ";
				}
				cout << endl;
			}
			for (int m = 0; m < o->c_list->modules.size(); m++) {
				cout << o->c_list->modules[m]->name << "[" << o->c_list->modules[m]->minSize << "," <<
						o->c_list->modules[m]->maxSize << "] = " <<o->c_list->modules[m]->modules.size() << " ids: ";
				for (int k = 0; k < o->c_list->modules[m]->modules.size(); k++) cout << o->c_list->modules[m]->modules[k]->id << " ";
				cout << endl;
				
			}
			o->c_list->accept(this); o->main_exp->accept(this); o->a_list->accept(this);
			cout << ")" << endl;
		}
		virtual void visitModuleRef(ModuleRef *o) { cout << string(indent,' ') << "ModuleRef" << endl;}
		virtual void visitModuleVar(ModuleVar *o) {
			cout << string(indent++,' ') << "ModuleVar[" << o->value << "]";
			cout << "(" << endl;
			o->mref->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitNumber(Number *o) {cout << string(indent,' ') << "Number" << endl;}
		virtual void visitMathExp(MathExp *o) {
			cout << string(indent++,' ') << "MathExp(" << endl;
			o->lval->accept(this); o->rval->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitCompExp(CompExp *o) {
			cout << string(indent++,' ') << "CompExp" << o->op << "(" << endl;
			o->lval->accept(this); o->rval->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitAndExp(AndExp *o) {
			cout << string(indent++,' ') << "AndExp(" << endl;
			o->lval->accept(this); o->rval->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitOrExp(OrExp *o) {
			cout << string(indent++,' ') << "OrExp(" << endl;
			o->lval->accept(this); o->rval->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitNotExp(NotExp *o) {
			cout << string(indent++,' ') << "NotExp(" << endl;
			o->val->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitNeighborExp(NeighborExp *o) {
			cout << string(indent++,' ') << "NeighborExp(" << endl;
			o->lval->accept(this); o->rval->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitModuleDecl(ModuleDecl *o) {cout << string(indent,' ') << "ModuleDecl" << endl;}
		virtual void visitModuleList(ModuleList *o) {
			cout << string(indent++,' ') << "ModuleList(" << endl;
			for(int i = 0; i < o->modules.size(); i++) o->modules[i]->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitSetVarAction(SetVarAction *o) {
			cout << string(indent++,' ') << "SetVarAction(" << endl;
			o->module->accept(this); o->value->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitChangeTopologyAction(ChangeTopologyAction *o) {
			cout << string(indent++,' ') << "ChangeTopoAction(" << endl;
			o->moduleA->accept(this); o->moduleB->accept(this);
			cout << string(--indent,' ') << ")" << endl;
			}
		virtual void visitCallFcnAction(CallFcnAction *o) {
			cout << string(indent++,' ') << "CallFcnAction(" << endl;
			o->module->accept(this); o->value->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitActionList(ActionList *o) {
			cout << string(indent++,' ') << "actionList(" << endl;
			for(int i = 0; i < o->actions.size(); i++) o->actions[i]->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitSetRExp(SetRExp *o) {
			cout << string(indent++,' ') << "SetRExp(" << endl;
			o->set->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitSetBExp(SetBExp *o) {
			cout << string(indent++,' ') << "SetBExp(" << endl;
			o->set->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitSetSExp(SetSExp *o) {
			cout << string(indent++,' ') << "SetSExp(" << endl;
			o->lval->accept(this); o->rval->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitSetVar(SetVar *o) {
			cout << string(indent++,' ') << "SetVar(" << endl;
			o->mref->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitCountExp(CountExp *o) {
			cout << string(indent++,' ') << "CountExp[" << o->required.size() << "," << o->optional.size() <<  "](" << endl;
			for(int i = 0; i < o->required.size(); i++) o->required[i]->accept(this);
			for(int i = 0; i < o->optional.size(); i++) o->optional[i]->accept(this);
			for(int i = 0; i < o->unexpanded.size(); i++) o->unexpanded[i]->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitIdxVar(IdxVar *o) {cout << string(indent,' ') << "IdxVar" << endl;}
		virtual void visitIdxModuleRef(IdxModuleRef *o) {
			cout << string(indent++,' ') << "IdxModuleRef(" << endl;
			o->idxExp->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
		virtual void visitKleeneParent(KleeneParent *o) {
			cout << string(indent++,' ') << "KleeneParent(" << endl;
			cout << "original: " << endl;;
			o->origExp->accept(this);
			cout << "required: " << endl;;
			for(int i = 0; i < o->required.size(); i++) o->required[i]->accept(this);
			cout << "optional: " << endl;
			for(int i = 0; i < o->optional.size(); i++) o->optional[i]->accept(this);
			cout << string(--indent,' ') << ")" << endl;
		}
};


#endif
