#include "DCTest.hxx"
#include <string>
#include <iostream>
#include <cstdlib>
#include <ctime>
#include <algorithm>

using namespace std;

class TestWrapper: public ModuleWrapper {
	public: 
		set<ModuleWrapper *> n;
		float randomVar;
		set<float> randomSet;
		DCondManager *manager;
		
		virtual set<ModuleWrapper *> neighbors() {return n;}
		
		virtual void send(DCMessage* msg, ModuleWrapper *dest) {
			if (!n.count(dest)) {
				cout << "trying to send message from " << id << " to non-neighbor " << dest->id << endl;
				return;
			}
			((TestWrapper*)dest)->manager->messageReceived(msg,this);
		}
		
		virtual float getRealVar(string varname) {
			if (varname == "random") return randomVar;
			else if (varname == "id") return id;
			cout << "unknown varname: " << varname << endl;
			return 0.0;
		}
		
		virtual void setRealVar(string varname, float val) {
			if (varname == "random") randomVar = val;
			else cout << "unknown varname: " << varname << endl;
		}
		
		virtual set<float> getSetVar(string varname) {
			if (varname == "$random") {return randomSet;}
			cout << "unknown setname: " << varname << endl;
			return set<float>();
		}
		
		virtual void setSetVar(string varname, set<float> val) {cout << "setSetVar not supported by language" << endl;}
		virtual void callFcn(string fname, float arg) {
			cout << id <<  " called " << fname << " with arg " << arg << endl;
		}
		
		void tick() {
			randomVar = rand() % 10;
			randomSet.clear();
			int size = rand() % 5;
			for (unsigned i = 0; i < size; i++) randomSet.insert(rand() % 10);
			manager->tick();
			//cout << ".";
		}
};

int main_old() {
	int xSize = 2;
	int ySize = 2;
	int numTicks = 5;
	
	srand((unsigned)time(0));
	//set up test wrappers
	vector<TestWrapper*> modules;
	for (unsigned i = 0; i < xSize*ySize; i++) {
		TestWrapper *newM = new TestWrapper();
		newM->id = i;
		newM->manager = new DCondManager(newM);
		modules.push_back(newM);
	}
	//set up 2D neighbor grid
	for (unsigned i = 0; i < xSize; i++) 
		for (unsigned j = 0; j < ySize; j++) {
			TestWrapper *c = modules[j*xSize + i];
			if (i != 0) c->n.insert(modules[j*xSize + i - 1]);
			if (i != xSize -1) c->n.insert(modules[j*xSize + i + 1]);
			if (j != 0) c->n.insert(modules[(j-1)*xSize + i]);
			if (j != ySize -1) c->n.insert(modules[(j+1)*xSize + i]);
		}
	
	cout << "parsing tests" << endl;
	//parsing/munging tests	
	PrintCondVisitor pv;
	//test count(), basic action
	string input = "(a); (count(n(a,b),!n(b,c), (a.foo == 3)) == 1) ; a.foo = 3 ;"; //works
	DCondition *cond = parseCondition(input);
	//test kleene*, set vars, dotted var names, multiple actions
	input = "(a[2,5]); a[i+1].prev(5).$foo.bar->empty? ; !n(a[1],b) & a.foo = 3 ;"; //works
	cond = parseCondition(input);
	//pv.visitDCondition(cond);
	//test using sets
	input = "(a,b); (count((a.$foo->size > 2),a.$foo->union(b.$foo)->empty?) != 2) ; a.callbackFcn(2) ;"; //works
	cond = parseCondition(input);
	
	cout << "Execution test" << endl;
	input = "(a,b); (a.random == b.random); a.callFcn(b.id);"; //passed
	input = "(a[2,2]); (a[0].random == a[1].random); a[0].callFcn(a[1].id);"; //passed
	input = "(a,b); (a.$random->size > b.$random->size) & !a.$random->empty?; b.callFcn(b.$random->union(a.$random)->size);"; //passed
	input = "(a,b,c); (count((a.id == 0),(b.id == 1), (c.id == 2)) == 3); c.random = a.id;"; //passed
	input = "(a,b[0,2],c); n(a,b[0]) & n(b[0],b[1]) & n(c,b[-1]); c.fallFcn(a.id + b[0].id + b[1].id + c.id);"; //passed
	cond = parseCondition(input);
	//pv.visitDCondition(cond);
	for (unsigned i = 0; i < xSize*ySize; i++) {
		modules[i]->manager->addCondition(cond);
	}
	
	for (unsigned i = 0; i < numTicks; i++) {
		vector<TestWrapper*>runOrder = modules;
		random_shuffle(runOrder.begin(),runOrder.end());
		for (unsigned j = 0; j < runOrder.size(); j++) runOrder[j]->tick();
	}
	
 	return 0;
 }
