#include "pathsupport.hxx"
#include "CatomWorld.hxx"
#include "Util.hxx"

int onGround(Point spot)
{
  if (spot.z <= 1.1)
    return 1;

  return 0;
}

Point myModule(Point spot)
{
  Point module;

  float x = spot.x;
  float y = spot.y;
  float z = spot.z;

  if (x < 0) x -= 2;
  if (y < 0) y -= 2;
  if (z < 0) z -= 2;

  module.x = ((int)(x / 4)) * 4.0 + 1;
  module.y = ((int)(y / 4)) * 4.0 + 1;
  module.z = ((int)(z / 4)) * 4.0 + 2;

  return module;
}


int inModule(Point spot, Point module)
{
  return
    (spot.x >= module.x - 1.1 &&
     spot.x <= module.x + 1.1) &&
    (spot.y >= module.y - 1.1 &&
     spot.y <= module.y + 1.1) &&
    (spot.z >= module.z - 1.1 &&
     spot.z <= module.z + 1.1);

}

int isLeader(Point spot)
{
  if (((int)spot.x) % 4 == 0 &&
      ((int)spot.y) % 4 == 0 &&
      ((int)spot.z) % 4 == 1)
    return 1;
  else
    return 0;
}

int latticeSpot(Point spot)
{
  if ((abs((int)spot.x)/2) % 2 +
      (abs((int)spot.y)/2) % 2 +
      (abs((int)spot.z)/2) %2 <= 1)
    return 1;
  else
    return 0;
}

static double distanceE(Point &a, Point &b)
{
  return
    pow(pow(a.x - b.x, 2.0) +
	pow(a.y - b.y, 2.0) +
	pow(a.z - b.z, 2.0), 0.5);
}

int closer(Point oldp, Point newp, Point src, Point dst)
{
  return
    (inModule(newp, dst) && inModule(oldp, src)) ||
    (inModule(newp, dst) && inModule(oldp, dst) &&
     distanceE(newp, src) > distanceE(oldp, src)) ||
    (inModule(newp, src) && inModule(oldp, src) &&
     distanceE(newp, dst) < distanceE(oldp, dst));
}

double dist(Point p, Point q)
{
  return magnitude(p - q);
}

int localTimeStamp()
{
  static int t = 0;

  return t++;
}

int canMoveTo(addr, Point p, Point q)
{
  double dist = pow(p.x - q.x, 2.0) +
                pow(p.y - q.y, 2.0) +
                pow(p.z - q.z, 2.0);

  //  cout << "dist = " << dist << endl;

  if (dist <= 8.1 && p.z >= 0.9) return 1;
  else return 0;
}

static map<string,hash_set<Point3D, HashPoint3D, EqualPoint3D> > targetMaps;

bool loadTarget(string name)
{
	if (targetMaps.find(name) == targetMaps.end()) {
		// init target
		string fname = worldPtr->search_key_value_list(name);
		if (fname == "") {
			fname = name;  // try file of that name if keypair not found
		}
		targetMaps[name] = hash_set<Point3D, HashPoint3D, EqualPoint3D>();
		if (loadPointHash(fname, targetMaps[name]) == false) {
			die("Couldn't load %s", fname.c_str());
		}
		hash_set<Point3D, HashPoint3D, EqualPoint3D>::iterator I;
	}
	return true;
}

int inTargetShape(Point p)
{
  return inTargetShape(Point3D(p.x, p.y, p.z), "TARGETFILE");
}

int inTargetShape(Point3D p, string name)
{
	loadTarget(name);
	if (targetMaps[name].find(p) != targetMaps[name].end()) {
		return 1;
	} else {
		return 0;
	}
}

