///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __MYMAILBOX_H
#define __MYMAILBOX_H

#include <pthread.h>

template <class MSG>
class mymailbox {
	deque<MSG> inbox[2];
	int inbox_tick;
	pthread_mutex_t inbox_lock;
public:
	mymailbox() : inbox_tick(0) { pthread_mutex_init( &inbox_lock, 0 ); };
	void send( mymailbox<MSG>& mb, const MSG& m ) {
		pthread_mutex_lock( &(mb.inbox_lock) );
		int i = (inbox_tick+1)&0x01;
		mb.inbox[i].push_back(m);
		pthread_mutex_unlock( &(mb.inbox_lock) );
	};
	MSG read() {
		MSG tmp;
		int i = inbox_tick&0x01;
		if (!inbox[i].empty()) {
			tmp = inbox[i].front();
			inbox[i].pop_front();
		}
		return tmp;
	};
	void done_this_tick() {
		int i = inbox_tick&0x01;
		int j = (inbox_tick+1)&0x01;
		pthread_mutex_lock( &inbox_lock );
		while (!inbox[i].empty()) {
			inbox[j].push_front( inbox[i].back() );
			inbox[i].pop_back();
		}
		inbox_tick++;
		pthread_mutex_unlock( &inbox_lock );
	};
};


#endif
