#include "cyclecount.hxx"
#include <assert.h>
#include "CatomWorld.hxx"
#include "Util.hxx"

long long int clockCycles(void) {
  long long int highOrder;
  long long int lowOrder;

  long long int output;
  
  // For Pentiums, you can get the number of clock cycles elapsed 
  // since the last reboot with the following assembler code:
  //__asm__ volatile (".byte 0x0f, 0x31" : "=a" (lowOrder), "=d" (highOrder));
  
  output = lowOrder | (highOrder << 32);

  return output;
}

/*
long long int clockCycles(void) {
  struct tms buf;

  times(&buf);

  return buf.tms_utime;
}
*/

static long long int startTime = 0;

void startTiming(void) {
  assert(startTime == 0);
  startTime = clockCycles();
}

long long int endTiming(void) {
  long long int endTime = clockCycles();

  assert(startTime != 0);
  if (endTime < startTime) {
	cout << "endTime = " << endTime << endl;
	cout << "startTime = " << startTime << endl;
      }
  assert(endTime >= startTime);

  endTime -= startTime;
  startTime = 0;

  return endTime;
}
