// Tid.hxx
// Nels Beckman
// Feb 28th 2007
//
// The definition of a transaction ID. This class should be extremely
//   small, hence why there is only a header. If it gets big, change
//   this.

#ifndef __TID_H
#define __TID_H

#include <iostream>
#include <pthread.h>

#include "Primitives.hxx"


class Tid {
public:
  // We don't have enough info to create our own transaction numbers.
  //   We need a unique catom id, and a unique transaction id.
  Tid(catomID);
  Tid(const Tid&);
  
  // I have to have a default constructor to use map...
  Tid();

  // Necessary so that this class can be used in the map data
  //   structure.
  bool operator<(const Tid&) const;
  Tid& operator=(const Tid&);
  bool operator==(Tid);
  bool operator!=(Tid);

  friend ostream& operator<<(ostream &out, Tid &tid);
protected:
  catomID nodeId;
  unsigned int transId;

  static pthread_mutex_t tidMutex;
  static unsigned int tidCounter;
};

#endif
