// Nels Beckman
// Tid.cc
// March 12, 2007
//

#include "Tid.hxx"
#include "Debugging/signpost.hxx"

unsigned int Tid::tidCounter = 0;

pthread_mutex_t Tid::tidMutex = PTHREAD_MUTEX_INITIALIZER;

Tid::Tid() {}

Tid::Tid(catomID _catomId) : nodeId(_catomId),
			     transId()
{
  pthread_mutex_lock( &tidMutex );
  transId = ++tidCounter;
  pthread_mutex_unlock( &tidMutex );
}

Tid::Tid(const Tid& _tid) {
  this->nodeId = _tid.nodeId;
  this->transId = _tid.transId;
}

bool Tid::operator<(const Tid& rhs) const {
  return (this->nodeId < rhs.nodeId) && (this->transId < rhs.transId); 
}

Tid& Tid::operator=(const Tid& rhs) {
  this->nodeId = rhs.nodeId;
  this->transId = rhs.transId;

  return *this;
}

bool Tid::operator==(Tid rhs) { 
  return (this->nodeId == rhs.nodeId) &&
    (this->transId == rhs.transId); 
}

bool Tid::operator!=(Tid rhs) {
  return !( (*this) == rhs );
}

ostream& operator<<(ostream &out, Tid &tid) {
  out << tid.nodeId << tid.transId;
  return out;
}
