///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TESTMESSAGING_H
#define __TESTMESSAGING_H

class Catom;
class Message;

#include "CodeModule.hxx"

#include "Network.hxx"

CODE_MODULE_PROTOTYPE( TestMessaging, TestMessaging );
extern MailboxID testMessagingBox;

class TestMessage : public Message {
protected:
  int payload;

public:
  TestMessage(MailboxID mailboxName, int dataValue) : 
    Message(mailboxName),
    payload(dataValue) { }
  virtual Message* clone() {
    TestMessage* c = new TestMessage(mailboxID, payload);
    c->messageID = this->messageID;
    return c;
  }
};

class TestMessaging : public CodeModule {
public:
  TestMessaging(catomID cid) : CodeModule(cid) { }
  void simulationStart();
  
  bool testIntentHandler(TestMessage* msg);
  bool testHeaderHandler(TestMessage* msg);
  bool testPayloadHandler(TestMessage* msg);
  bool testFastIntentHandler(TestMessage* msg);
  bool testFastHeaderHandler(TestMessage* msg);
  bool testFastPayloadHandler(TestMessage* msg);
  
protected:
  virtual void endTick();
  
  virtual StateFile::Module* StateFileConstructor( void );
};

#endif
