///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>

#include "TestMessaging.hxx"

CODE_MODULE_DECLARATION( TestMessaging, TestMessaging );


#include "Catom.hxx"
#include "CatomSim.hxx"
#include "CatomWorld.hxx"
#include "Network.hxx"

MailboxID testMessagingBox = "testMessagingBox";
MailboxID testMessagingFastBox = "testMessagingFastBox";

using namespace std;

void TestMessaging::simulationStart() {
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(testMessagingBox,
								   this,
								   (msgHandlerPtr)&TestMessaging::testIntentHandler,
								   MSGINTENT);
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(testMessagingBox,
								   this,
								   (msgHandlerPtr)&TestMessaging::testHeaderHandler,
								   MSGHEADER);
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(testMessagingBox,
								   this,
								   (msgHandlerPtr)&TestMessaging::testPayloadHandler,
								   MSGPAYLOAD);

  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(testMessagingFastBox,
								   this,
								   (msgHandlerPtr)&TestMessaging::testFastIntentHandler,
								   MSGINTENT,
								   false);
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(testMessagingFastBox,
								   this,
								   (msgHandlerPtr)&TestMessaging::testFastHeaderHandler,
								   MSGHEADER,
								   false);
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(testMessagingFastBox,
								   this,
								   (msgHandlerPtr)&TestMessaging::testFastPayloadHandler,
								   MSGPAYLOAD,
								   false);
}

void TestMessaging::endTick() {
  if((random() % 1000) == 0) {
    // Send message to random neighbor
    Feature* featureMap = worldPtr->catomHash[hostCatom]->C.getFeatureMap();
    TestMessage* msg;
    
    featureID startfid = random() % NUM_FEATURES;
    featureID fid = startfid;
    do {
      if(fid == 0)
	fid++;
      
      worldPtr->oStart();
      if(random() % 2) {
	msg = new TestMessage(testMessagingBox, 42);
	cerr << "Catom " << hostCatom << " sending regular message at tick " << worldPtr->current_time << endl;
      } else {
	msg = new TestMessage(testMessagingFastBox, 42);
	cerr << "Catom " << hostCatom << " sending fast message at tick " << worldPtr->current_time << endl;
      }
      worldPtr->oEnd();
      
      if(featureMap[fid].getNetworkAdapter()->sendMessage(msg))
	return;
      
      fid = (fid+1) % NUM_FEATURES;
    } while (fid != startfid);
  }
}

bool TestMessaging::testIntentHandler(TestMessage* msg) {
  worldPtr->oStart();
  cerr << hostCatom << "'s testIntentHandler called at tick " << worldPtr->current_time << endl;
  worldPtr->oEnd();
  return false;
}

bool TestMessaging::testHeaderHandler(TestMessage* msg) {
  worldPtr->oStart();
  cerr << hostCatom << "'s testHeaderHandler called at tick " << worldPtr->current_time << endl;
  worldPtr->oEnd();
  return false;
}

bool TestMessaging::testPayloadHandler(TestMessage* msg) {
  worldPtr->oStart();
  cerr << hostCatom << "'s testPayloadHandler called at tick " << worldPtr->current_time << endl;
  worldPtr->oEnd();
  return false;
}

bool TestMessaging::testFastIntentHandler(TestMessage* msg) {
  worldPtr->oStart();
  cerr << hostCatom << "'s testIntentHandler called at tick " << worldPtr->current_time << endl;
  worldPtr->oEnd();
  return false;
}

bool TestMessaging::testFastHeaderHandler(TestMessage* msg) {
  worldPtr->oStart();
  cerr << hostCatom << "'s testHeaderHandler called at tick " << worldPtr->current_time << endl;
  worldPtr->oEnd();
  return false;
}

bool TestMessaging::testFastPayloadHandler(TestMessage* msg) {
  worldPtr->oStart();
  cerr << hostCatom << "'s testPayloadHandler called at tick " << worldPtr->current_time << endl;
  worldPtr->oEnd();
  return false;
}

StateFile::Module* TestMessaging::StateFileConstructor() {
  return NULL;
}
