///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TESTAGGREGATION_UTILS_HXX
#define __TESTAGGREGATION_UTILS_HXX

#include "Hierarchy.hxx"
#include "Network.hxx"
#include "Primitives.hxx"

using namespace std;

class TestAggregationChildData : public ChildData {
public:
  TestAggregationChildData(double _value=0.0, unsigned long _weight=0, long _timeLastUpdated=-1) : value(_value), weight(_weight), timeLastUpdated(_timeLastUpdated) {};
  double value;
  unsigned long weight;
  long timeLastUpdated;

  virtual ChildData* clone() { return new TestAggregationChildData(value, weight, timeLastUpdated); }
};

class TestAggregationMsg : public Message {
public:
  TestAggregationMsg(MailboxID _box, catomID _from, double _value, unsigned long _weight, simtime _timestamp);
  TestAggregationMsg(MailboxID _box, unsigned long long _msgID, catomID _from, double _value, unsigned long _weight, simtime _timestamp);
  
  catomID from;
  double value;
  unsigned long weight;
  simtime timestamp;

  virtual Message* clone() {
    TestAggregationMsg* c = new TestAggregationMsg(mailboxID, messageID, from, value, weight, timestamp);
    c->messageID = this->messageID;
    return c;
  }

  virtual unsigned long long payloadSize() { return sizeof(from) + sizeof(value) + sizeof(weight) + Message::payloadSize(); }

  virtual string logString();
};

#endif
