///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "TestAggregationUtils.hxx"

#include "DPRSim.hxx"
#include "signpost.hxx"
#include "StatsManager.hxx"

#include <sstream>

using namespace std;

TestAggregationMsg::TestAggregationMsg(MailboxID _box, catomID _from, double _value, unsigned long _weight, simtime _timestamp) :
    Message(_box),
    from(_from),
    value(_value),
    weight(_weight),
    timestamp(_timestamp) {
  statsMgrPtr->counterInc("aggMessages", _box);
};
TestAggregationMsg::TestAggregationMsg(MailboxID _box, unsigned long long _msgID, catomID _from, double _value, unsigned long _weight, simtime _timestamp) :
  Message(_box, _msgID),
  from(_from),
  value(_value),
  weight(_weight),
  timestamp(_timestamp) {
  statsMgrPtr->counterInc("aggMessages", _box);
};

string TestAggregationMsg::logString() {
  stringstream ss;
  ss << value << " " << weight;
  
  return ss.str();
}
