
#include "TestAggregationHBTradFail.hxx"

#include "CatomWorld.hxx"
#include "DPRSim.hxx"

static bool pref_randFailParent = false;
static bool pref_stopAfterFail = false;
static float pref_parentFailProb = 0.0;
static map<catomID,simtime> pref_deadCatoms = map<catomID,simtime>();

TestAggregationHBTradFail::TestAggregationHBTradFail(catomID _hostCatom, string _hierarchyName) : 
  DPRHierarchy(_hostCatom, _hierarchyName),
  hasFailed(false)
{}

void TestAggregationHBTradFail::simulationStart() {
  string catomsToDie = worldPtr->search_key_value_list("HBDEADCATOMS");
  if( catomsToDie != "" ) {
    class ParseException {};
    
    try {
      for( unsigned i = 0; i < catomsToDie.size(); i++ ) {
	if( catomsToDie[i] == ',' ) i++;
	if( catomsToDie[i] != '(' ) throw ParseException();
	
	i++;
	string catom_id = "";
	do {
	  catom_id = catom_id + catomsToDie[i];
	  i++;
	  if( i >= catomsToDie.size() ) throw ParseException();
	} while( catomsToDie[i] != ',' );
	
	cerr << "Catom ID parsed: " << catom_id << endl;
	
	i++;
	if( i >= catomsToDie.size() ) throw ParseException();
	
	string time_to_die = "";
	do {
	  time_to_die = time_to_die + catomsToDie[i];
	  i++;
	  if( i >= catomsToDie.size() ) throw ParseException();
	} while( catomsToDie[i] != ')' );
	
	cerr << "Time to kill parsed: " << time_to_die << endl;
	
	// Put this catom/time pair in the map.
	{
	  long cid_long = atol(catom_id.c_str());
	  long ttd_long = atol(time_to_die.c_str());
	  pref_deadCatoms[cid_long] = ttd_long;
	}
      }
    } catch(ParseException pe) {
      cerr << "Could not parse list of dead catoms." << endl;
    }
  }
  
  string randFail = worldPtr->search_key_value_list("RANDFAILPARENT");
  if( randFail != "" )
    pref_randFailParent = true;
  else 
    pref_randFailParent = false;
  
  string failStop = worldPtr->search_key_value_list("STOPAFTERFAIL");
  if( failStop != "" )
    pref_stopAfterFail = true;
  
  string pFailProb = worldPtr->search_key_value_list("PARENTFAILPROB");
  if( pFailProb != "" )
    pref_parentFailProb = strtod(pFailProb.c_str(), NULL);

  
  DPRHierarchy::simulationStart();
}


void TestAggregationHBTradFail::endTick() {
  if(!hasFailed) {
    // See if you need to fail.
    bool will_die = pref_deadCatoms.count(hostCatom) > 0;
    simtime t = will_die ? pref_deadCatoms[hostCatom] : 0;
    
    if( will_die && 
	(t == worldPtr->current_time) ) {
      
      hasFailed = true;
      if( getLevel() > 1 ) {
	
	cerr << hostCatom << " Time: " << worldPtr->current_time 
	     << " FAILED ****************\n";
	exit(0);
      }
      else {
	cerr << hostCatom << " Time: " << worldPtr->current_time 
	     << " Level: " << getLevel()
	     << " PARENTFAILED ****************\n";
	
	
      }
      
    }
    else if( pref_randFailParent && 
	     worldPtr->current_time >= pref_fastStartEndTime ) {
      if( getLevel() > 1 ) {
	// So yes, I am a parent.
	float val = (float)((double)random() / (double)RAND_MAX);
	if( val <= pref_parentFailProb ) {
	  hasFailed = true;
	  cerr << hostCatom << " Time: " << worldPtr->current_time 
	       << " Level: " << getLevel()
	       << " PARENTFAILED ****************\n";

	  if( pref_stopAfterFail )
	    worldPtr->timesteps = worldPtr->current_time + 1;
	}
      }
    }
  }
  
  // Let the superclass do its thing
  DPRHierarchy::endTick();
  
  // Weird, huh...
  if(hasFailed)
    return;
}
