///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TESTAGGREGATION_HXX
#define __TESTAGGREGATION_HXX

#include "DPRHierarchy.hxx"
#include "GradientHierarchy.hxx"
#include "DPRHierarchy-HotBackups.hxx"

#include "Network.hxx"

#ifdef USETRADHCHY
#define TESTAGG_CLASS TestAggregationHBTrad
#define TESTAGG_SUPER DPRHierarchy
CODE_MODULE_PROTOTYPE( TestAggregationHBTrad, TestAggregationHBTrad, "TestAggregationHBTrad" );
#else
#define TESTAGG_CLASS TestAggregationHB
#define TESTAGG_SUPER DPRHierarchyHotBackups
CODE_MODULE_PROTOTYPE( TestAggregationHB, TestAggregationHB, "TestAggregationHB" );
#endif

class TESTAGG_CLASS : public TESTAGG_SUPER {
public:
  TESTAGG_CLASS(catomID _hostCatom, string _hierarchyName);
  virtual ~TESTAGG_CLASS();
  virtual void simulationStart();
  bool aggMessageHandler(Message* _msg);
  
protected:
  double myAggregateValue;
  simtime timeLastAggregateSent;
  
  MailboxID testAggregationBox;
  
  virtual void endTick();
  virtual ChildData* newChildDataObject();

  virtual void setChildData(catomID, ChildData*);

  virtual bool failoverBeaconHandler(HotBackupFailoverBeacon* msg);
  
  void sendAggToParent();
  double lastValueSent;
  unsigned long lastWeightSent;
  simtime leafNextEmitTime;
  simtime currentCollectionIntervalStartTime;

#ifdef USETRADHCHY
  bool keepaliveHandler(HotBackupKeepalive*);
  simtime lastKeepaliveHeardTime;
  simtime lastKeepaliveSendTime;
  simtime failoverStart;
  bool isConsistent;
#endif
};

#endif
