///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "TestAggregationHB.hxx"

#include "CatomWorld.hxx"
#include "signpost.hxx"
#include "CatomSim.hxx"
#include "StatsManager.hxx"
#include "TestAggregationUtils.hxx"

extern StatsManager* statsMgrPtr;

static simtime pref_childEmissionInterval = 100;
static simtime pref_collectionPeriodLength = 500;

extern string hotBackupFailoverBeaconMailbox; // in DPRHierarchy-HotBackups.cxx

static int pref_workUnitsToDo = -1;

#ifdef USETRADHCHY
CODE_MODULE_DECLARATION( TestAggregationHBTrad, TestAggregationHBTrad, "TestAggregationHBTrad" );
#else
CODE_MODULE_DECLARATION( TestAggregationHB, TestAggregationHB, "TestAggregationHB" );
#endif

#ifdef USETRADHCHY
static bool pref_useLocalRepair = true;
#endif

using namespace std;


TESTAGG_CLASS::TESTAGG_CLASS(catomID _hostCatom, string _hierarchyName) :
  TESTAGG_SUPER(_hostCatom, _hierarchyName),
  timeLastAggregateSent(INVALID_SIM_TIME),
  testAggregationBox("TestAggregationBox_" + _hierarchyName),
  lastValueSent(-1),
  lastWeightSent(0),
  leafNextEmitTime(INVALID_SIM_TIME),
  currentCollectionIntervalStartTime(INVALID_SIM_TIME)
#ifdef USETRADHCHY
  ,
  lastKeepaliveHeardTime(0),
  lastKeepaliveSendTime(0),
  failoverStart(0),
  isConsistent(false)
#endif
{ }

TESTAGG_CLASS::~TESTAGG_CLASS() { }

void TESTAGG_CLASS::simulationStart() {
  TESTAGG_SUPER::simulationStart();
  
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(testAggregationBox,
								   this,
								   (msgHandlerPtr)&TESTAGG_CLASS::aggMessageHandler,
								   MSGPAYLOAD,
								   true);


  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(hotBackupFailoverBeaconMailbox,
								   this,
								   (msgHandlerPtr)&TESTAGG_CLASS::failoverBeaconHandler);
  
#ifdef USETRADHCHY
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(hotBackupKeepaliveMailbox,
								   this,
								   (msgHandlerPtr)&TESTAGG_CLASS::keepaliveHandler);
#endif

  string s;

  s = worldPtr->search_key_value_list("HBEMITINTERVAL");
  if(s != "")
    pref_childEmissionInterval = strtol(s.c_str(), NULL, 0);

  s = worldPtr->search_key_value_list("HBCOLLECTPERIOD");
  if(s != "")
    pref_collectionPeriodLength = strtol(s.c_str(), NULL, 0);

  s = worldPtr->search_key_value_list("WORKUNITS");
  if( s != "" )
    pref_workUnitsToDo = atoi( s.c_str() );
}

bool TESTAGG_CLASS::aggMessageHandler(Message* _msg) {
  TestAggregationMsg* msg = (TestAggregationMsg*)_msg;

  TestAggregationChildData* theChildData = (TestAggregationChildData*)this->newChildDataObject();
  assert(theChildData != NULL);
  theChildData->value = msg->value;
  theChildData->weight = msg->weight;
  theChildData->timeLastUpdated = worldPtr->current_time;

  setChildData(msg->from, theChildData);

  if(currentCollectionIntervalStartTime == INVALID_SIM_TIME)
    currentCollectionIntervalStartTime = worldPtr->current_time;
  
  return false;
}

void TESTAGG_CLASS::sendAggToParent() {
  double ourVal = myAggregateValue;
  unsigned long ourWeight = 1;
  
  list<catomID> catomIDs = childCatomIDs();
  list<catomID>::iterator childDataIterator = catomIDs.begin();
  while(childDataIterator != catomIDs.end()) {
    TestAggregationChildData* theChildData = (TestAggregationChildData*)getChildData(*childDataIterator);
    
    ourVal += theChildData->value * theChildData->weight;
    ourWeight += theChildData->weight;

    delete theChildData;
    
    childDataIterator++;
  }
  
  ourVal /= ourWeight;
  
  
  TestAggregationMsg* msg = new TestAggregationMsg(testAggregationBox, hostCatom, ourVal, ourWeight, worldPtr->current_time);
  if(!sendMsgToParent(msg)) {
    worldPtr->oStart();
    cerr << worldPtr->current_time << " root " << hostCatom << "(level " << level << ") emits aggregate value " << ourVal << " (weight " << ourWeight << ")\n";
    //cerr << "    Peers count: " << peers.size() << endl;
    worldPtr->oEnd();

    static int work_units_done = 0;
    work_units_done++;

    // This is where a work unit occurs.
    if( work_units_done == pref_workUnitsToDo ) {
      worldPtr->timesteps = worldPtr->current_time + 1;
    }
  }
  
  lastValueSent = ourVal;
  lastWeightSent = ourWeight;
  
  timeLastAggregateSent = worldPtr->current_time;
}

ChildData* TESTAGG_CLASS::newChildDataObject() {
  return new TestAggregationChildData();
}

void TESTAGG_CLASS::endTick() {
  if(worldPtr->current_time >= pref_fastStartEndTime) {
    list<catomID> childrenIDs = childCatomIDs();

    // Prevent treating data we're holding as a hot backup from being treated as our own children
#ifdef USETRADHCHY
    if(false) {
#else
    if(claimedAsHotBackup != INVALID_CATOM_ID ) {
#endif
      childrenIDs.clear();
    } else if(childrenIDs.size() == 0) {
      // If we don't have any children (we're a leaf), see if it's time to send something yet
      if(worldPtr->current_time == leafNextEmitTime) {
	myAggregateValue = (double)random() / LONG_MAX;
	sendAggToParent();
      }

      // Set a new time if it's anywhere in the past
      if((leafNextEmitTime == INVALID_SIM_TIME) || 
	 (leafNextEmitTime <= worldPtr->current_time)) {
	leafNextEmitTime = worldPtr->current_time + (random() % pref_childEmissionInterval) + 1;
      }

#ifdef USETRADHCHY
      if(pref_useLocalRepair &&
	 (lastKeepaliveHeardTime > 0) &&
	 (worldPtr->current_time - lastKeepaliveHeardTime) == (pref_keepaliveInterval+1)) {
	failoverStart = worldPtr->current_time;
	isConsistent = false;
	cerr << worldPtr->current_time << " " << hostCatom << " declares its parent dead\n";

	setParent(INVALID_CATOM_ID);
	lastKeepaliveHeardTime = 0;

	// Emit BeaconRequestBeacon
	for(unsigned int i=1; i<=NUM_FEATURES; i++) {
	  Feature* contact = &((worldPtr->catomHash[hostCatom]->C.getFeatureMap())[i]);
	  contact->getNetworkAdapter()->sendMessage(new BeaconRequestBeacon(this->beaconRequestBox,
									    worldPtr->current_time,
									    visibilityDistance));
	}
      }
#endif
    } else {
      // If we do have chidren (we're not a leaf), send an aggregation if the current collection interval has ended
      if((currentCollectionIntervalStartTime != INVALID_SIM_TIME) &&
	 ((worldPtr->current_time - currentCollectionIntervalStartTime) == pref_collectionPeriodLength)) {
	sendAggToParent();
	currentCollectionIntervalStartTime = INVALID_SIM_TIME;
      }

#ifdef USETRADHCHY
      // Send a keepalive to our children if it's time
      if(pref_useLocalRepair &&
	 ((worldPtr->current_time - lastKeepaliveSendTime) >= pref_keepaliveInterval)) {
	list<catomID>::iterator childIter = childrenIDs.begin();
	while(childIter != childrenIDs.end()) {
	  routeLandmarkMsg(new LandmarkMsg(this, *childIter, new HotBackupKeepalive(visibilityDistance)));
	  childIter++;
	}
      }
#endif
    }
  }

  TESTAGG_SUPER::endTick();
}

bool TESTAGG_CLASS::failoverBeaconHandler(HotBackupFailoverBeacon* msg) {
#ifndef USETRADHCHY  
  TESTAGG_SUPER::failoverBeaconHandler(msg);
#endif

  if(getParent() == msg->newCatom)
    sendAggToParent();

  return false;
}

void TESTAGG_CLASS::setChildData(catomID childID, ChildData* data) {
  
  TESTAGG_SUPER::setChildData(childID, data);

#ifndef USETRADHCHY
  // If we are a hot backup and we are in the period where we wait for
  //   messages from each of our children.
  if( !isConsistent ) {
    bool found_outdated = false;

    list<catomID> child_list = childCatomIDs();

    for( list<catomID>::iterator iter = child_list.begin();
	 iter != child_list.end();
	 iter++ ) {

      TestAggregationChildData* data = 
	(TestAggregationChildData*)getChildData( (*iter) );

      if( data->timeLastUpdated < failoverStart )
	found_outdated = true;

      delete data;
    }

    if( !found_outdated ) {
      isConsistent = true;
      cerr << "Catom " << hostCatom 
	   << " a hot backup, is consistent at time: " 
	   << worldPtr->current_time << endl;
    }
  }
#endif
}

#ifdef USETRADHCHY
bool TESTAGG_CLASS::keepaliveHandler(HotBackupKeepalive* msg) {
  lastKeepaliveHeardTime = worldPtr->current_time;

  if((msg->visDistance+1) > visibilityDistance) {
    visibilityDistance = msg->visDistance+1;
    landmarkAnnounce();
  }

  return false;
}
#endif
