///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __TESTAGGREGATION_HXX
#define __TESTAGGREGATION_HXX

#include "DPRHierarchy.hxx"
#include "GradientHierarchy.hxx"
#include "DPRHierarchy-HotBackups.hxx"

#include "Network.hxx"

//#define USEGRADIENTHCHY
//#undef USEGRADIENTHCHY

#if defined(USEGRADIENTHCHY)
#define TESTAGG_CLASS TestAggregationGradient
#define TESTAGG_SUPER GradientHierarchy
CODE_MODULE_PROTOTYPE( TestAggregationGradient, TestAggregationGradient, "TestAggregationGradient" );
#else
#define TESTAGG_CLASS TestAggregationDPR
#define TESTAGG_SUPER DPRHierarchy
CODE_MODULE_PROTOTYPE( TestAggregationDPR, TestAggregationDPR, "TestAggregationDPR" );
#endif

//CODE_MODULE_PROTOTYPE( TestAggregation, TestAggregation, "TestAggregation" );


class TestAggregationMsg;

class TESTAGG_CLASS : public TESTAGG_SUPER {
public:
  TESTAGG_CLASS(catomID _hostCatom, string _hierarchyName);
  virtual ~TESTAGG_CLASS();
  virtual void simulationStart();
  bool aggMessageHandler(TestAggregationMsg* _msg);
  
protected:
  double myAggregateValue;
  long timeLastAggregateSent;
  
  MailboxID testAggregationBox;
  
  virtual void endTick();
  virtual ChildData* newChildDataObject();
  
  void sendAggToParent();
  double lastValueSent;
  unsigned long lastWeightSent;
};

#endif
