///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "TestAggregation.hxx"

#include "CatomWorld.hxx"
#include "signpost.hxx"
#include "CatomSim.hxx"
#include "StatsManager.hxx"
#include "TestAggregationUtils.hxx"

extern StatsManager* statsMgrPtr;

static long thinkTime = 30;
static unsigned long aggInterval = 99999;

#define STAGGERED_START_SPAN 30

#if defined(USEGRADIENTHCHY)
CODE_MODULE_DECLARATION( TestAggregationGradient, TestAggregationGradient, "TestAggregationGradient" );
#else
CODE_MODULE_DECLARATION( TestAggregationDPR, TestAggregationDPR, "TestAggregationDPR" );
CODE_MODULE_DECLARATION( TestAggregationDPR2, TestAggregationDPR, "TestAggregationDPR2" );
CODE_MODULE_DECLARATION( TestAggregationDPR3, TestAggregationDPR, "TestAggregationDPR3" );
#endif


using namespace std;


TESTAGG_CLASS::TESTAGG_CLASS(catomID _hostCatom, string _hierarchyName) :
  TESTAGG_SUPER(_hostCatom, _hierarchyName),
  timeLastAggregateSent(-1),
  testAggregationBox("TestAggregationBox_" + _hierarchyName),
  lastValueSent(-1),
  lastWeightSent(0)
{
  myAggregateValue = random();
}

TESTAGG_CLASS::~TESTAGG_CLASS() { }

void TESTAGG_CLASS::simulationStart() {
  TESTAGG_SUPER::simulationStart();
  
  worldPtr->catomHash[hostCatom]->C.mailboxManager.registerHandler(testAggregationBox,
								   this,
								   (msgHandlerPtr)&TESTAGG_CLASS::aggMessageHandler,
								   MSGPAYLOAD,
								   true);

  string thinkTimeString = worldPtr->search_key_value_list("THINKTIME");
  if(thinkTimeString != "")
    thinkTime = strtol(thinkTimeString.c_str(), NULL, 0);

  string aggIntervalString = worldPtr->search_key_value_list("AGGINTERVAL");
  if(aggIntervalString != "")
    aggInterval = strtoul(aggIntervalString.c_str(), NULL, 0);
}

bool TESTAGG_CLASS::aggMessageHandler(TestAggregationMsg* msg) {
  TestAggregationChildData* theChildData = (TestAggregationChildData*)this->newChildDataObject();
  assert(theChildData != NULL);
  theChildData->value = msg->value;
  theChildData->weight = msg->weight;
  theChildData->timeLastUpdated = worldPtr->current_time;

  setChildData(msg->from, theChildData);
  
  return false;
}

void TESTAGG_CLASS::sendAggToParent() {
  double ourVal = myAggregateValue;
  unsigned long ourWeight = 1;
  
  list<catomID> catomIDs = childCatomIDs();
  list<catomID>::iterator childDataIterator = catomIDs.begin();
  while(childDataIterator != catomIDs.end()) {
    TestAggregationChildData* theChildData = (TestAggregationChildData*)getChildData(*childDataIterator);
    
    ourVal += theChildData->value * theChildData->weight;
    ourWeight += theChildData->weight;

    delete theChildData;
    
    childDataIterator++;
  }
  
  ourVal /= ourWeight;
  
  // Only send an update if it's a new value or weight, or if the previous one was in a previous agg epoch
  if(((ourVal != lastValueSent) || (ourWeight != lastWeightSent)) ||
     (floor((timeLastAggregateSent - pref_fastStartEndTime) / aggInterval) !=
      floor((worldPtr->current_time - pref_fastStartEndTime) / aggInterval))
     ) {
    TestAggregationMsg* msg = new TestAggregationMsg(testAggregationBox, hostCatom, ourVal, ourWeight, worldPtr->current_time);
    if(!sendMsgToParent(msg)) {
      worldPtr->oStart();
      cerr << worldPtr->current_time << " root " << hostCatom << "(level " << level << ") emits aggregate value " << ourVal << " (weight " << ourWeight << ")\n";
      //cerr << "    Peers count: " << peers.size() << endl;
      worldPtr->oEnd();
      
      if((worldPtr->current_time > pref_fastStartEndTime) && (aggInterval == 99999))
	worldPtr->timesteps = worldPtr->current_time + 100;
    }

    lastValueSent = ourVal;
    lastWeightSent = ourWeight;
  }

  timeLastAggregateSent = worldPtr->current_time;
}

ChildData* TESTAGG_CLASS::newChildDataObject() {
  return new TestAggregationChildData();
}

void TESTAGG_CLASS::endTick() {
  if(worldPtr->current_time >= pref_fastStartEndTime) {
    list<catomID> childrenIDs = childCatomIDs();

    if(childrenIDs.size() == 0) {
      // If we don't have any children (we're a leaf), send an aggregation at different times within
      // STAGGERED_START_SPAN of each aggregation epoch's start (every aggInterval ticks starting at pref_fastStartEndTime)
      unsigned long myStaggeredStartIdx = hostCatom % STAGGERED_START_SPAN;
      if(((worldPtr->current_time - pref_fastStartEndTime) % aggInterval) == myStaggeredStartIdx)
	sendAggToParent();
    } else {
      // If we do have chidren (we're not a leaf), send an aggregation if:
      // - every child has reported in this aggregation epoch, and
      // - it's been exactly thinkTime ticks since the last report
      list<catomID>::iterator idIter = childrenIDs.begin();
      bool allChildrenReported = true;

      long lastReportTime = -1;
      while(allChildrenReported && (idIter != childrenIDs.end())) {
	TestAggregationChildData* childData = (TestAggregationChildData*)getChildData(*idIter);
	
	if((childData->timeLastUpdated == -1) ||
	   (floor((childData->timeLastUpdated - pref_fastStartEndTime) / aggInterval) !=
	    floor((worldPtr->current_time - pref_fastStartEndTime) / aggInterval)))
	  allChildrenReported = false;

	if(childData->timeLastUpdated > lastReportTime)
	  lastReportTime = childData->timeLastUpdated;

	delete childData;

	idIter++;
      }

      if(allChildrenReported &&
	 (lastReportTime != -1) &&
	 ((worldPtr->current_time - lastReportTime) == thinkTime))
	sendAggToParent();
    }
  } else if (worldPtr->current_time == floor(pref_fastStartEndTime*0.8)) {
    // At 4/5 of the way through the fast start period, hopefully the hchy is all built
    // Everybody message their parent to populate the child lists of the catoms
    //sendAggToParent();
    // Unnecessary now, since we're keeping the child lists up to date anyway in Hierarchy.cxx
  }

  TESTAGG_SUPER::endTick();
}
