///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>
#include <stdlib.h>

#include "Sprinkle2D.hxx"

#include "CatomWorld.hxx"
#include "CatomSim.hxx"

CODE_MODULE_DECLARATION( Sprinkle2D, Sprinkle2D );

using namespace std;

pthread_mutex_t Sprinkle2D::lock = PTHREAD_MUTEX_INITIALIZER;

void Sprinkle2D::simulationStart() {
  // force motion in 2D plane
  //dJointID planeJointID = dJointCreatePlane2D( worldPtr->dyn_world, 0);
  //dJointAttach( planeJointID, HOSTCATOMSIM->body, 0 );
}

void Sprinkle2D::newTick() {
  // restrict orientations to 1-axis rotations, i.e.,
  // force axis alignment to z axis
   pthread_mutex_lock( &lock );
   dBodyID bodyID = HOSTCATOMSIM->body;
   const dReal *rot = dBodyGetAngularVel( bodyID );
   const dReal *quat_ptr;
   dReal quat[4], quat_len;
   quat_ptr = dBodyGetQuaternion( bodyID );
   quat[0] = quat_ptr[0];
   quat[1] = 0;
   quat[2] = 0; 
   quat[3] = quat_ptr[3]; 
   quat_len = sqrt( quat[0] * quat[0] + quat[3] * quat[3] );
   quat[0] /= quat_len;
   quat[3] /= quat_len;
   dBodySetQuaternion( bodyID, quat );
   dBodySetAngularVel( bodyID, 0, 0, rot[2] );
   // do the same for positoin and velocity
   const dReal *vel = dBodyGetLinearVel( bodyID );
   const dReal *pos = dBodyGetPosition( bodyID );
   dBodySetPosition( bodyID, pos[0], pos[1], 1 );
   dBodySetLinearVel( bodyID, vel[0], vel[1], 0 );
   pthread_mutex_unlock( &lock );
}

void Sprinkle2D::simulationEnd() {
  pthread_mutex_lock( &lock);
  const dReal *rot = dBodyGetQuaternion( HOSTCATOMSIM->body );
  double angle = 2 * acos ( rot[0] );
  if (rot[3]<0) angle = -angle;
  Point3D p = HOSTCATOM.getLocation();
  cout << "FOO: " << rot[0] << " " << rot[1] << " " << rot[2] << " " << rot[3] << "\n";
  cout << "END: " << hostCatom << " " << p.getX() << " " << p.getY() << " " << angle << "\n";
  pthread_mutex_unlock( &lock);
}

void Sprinkle2D::oracle() {
  catomID startID=0;
  catomID endID=0xffffffff;
  double Y = 10;
  double Xstart = 0, Xend = 10;
  double Rate = 1.0;
  long n = 0;

  // running with simulationStart()

  // get options from experiment file
  string tmp;
  tmp = worldPtr->search_key_value_list( "Sprinkle2D_startID" );
  if (tmp!="") startID = strtoul( tmp.c_str(), 0, 0 );
  tmp = worldPtr->search_key_value_list( "Sprinkle2D_endID" );
  if (tmp!="") endID = strtoul( tmp.c_str(), 0, 0 );
  tmp = worldPtr->search_key_value_list( "Sprinkle2D_Xstart" );
  if (tmp!="") Xstart = strtod( tmp.c_str(), 0 );
  tmp = worldPtr->search_key_value_list( "Sprinkle2D_Xend" );
  if (tmp!="") Xend = strtod( tmp.c_str(), 0 );
  tmp = worldPtr->search_key_value_list( "Sprinkle2D_Y" );
  if (tmp!="") Y = strtod( tmp.c_str(), 0 );
  tmp = worldPtr->search_key_value_list( "Sprinkle2D_Rate" );
  if (tmp!="") Rate = strtod( tmp.c_str(), 0 );
  tmp = worldPtr->search_key_value_list( "Sprinkle2D_n" );
  if (tmp!="") n = strtoul( tmp.c_str(), 0, 0 );

  double t = 0.0;
  //catomID cID = endID;
  vector<catomID> cIDs;
  //hash_map<const unsigned long, CatomSim *, hash<const unsigned long>, equl>::iterator cit = worldPtr->catomHash.end();
  hash_map<const unsigned long, CatomSim *, hash<const unsigned long>, equl>::iterator cit = worldPtr->catomHash.begin();
  while (cit!=worldPtr->catomHash.end()) {
    if (cit->first >= startID && cit->first <= endID) cIDs.push_back( cit->first );
    if (n==0) {
	worldPtr->catomHash[cit->first]->magic_force = Point3D(0,-1,0)*CatomSim::catom_mass;
	double xv = (((double)rand())/RAND_MAX)*30.0-15.0;
	double yv = (((double)rand())/RAND_MAX)*30.0-15.0;
	dBodySetLinearVel( worldPtr->catomHash[cit->first]->body, xv, yv, 0 );
    }
    cit++;
  }
  unsigned int k = cIDs.size();
  if (k==0) cerr << "Sprinkle: ERROR - no catoms in ID range\n";
  else cerr << "Sprinkle: found " << k << " catoms in ID range\n";
  CatomSim *c;

  oracleYield();

  if (n) do {
    // running with oracles only
    while ( t < 1.0 ) {

      // get next catom in range
      //bool already_wrapped = false;
      //while (1) {
        //if (cID==endID) {
        //if (cit==worldPtr->catomHash.end()) {
          //if (already_wrapped) {
            //cerr << "Sprinkle: ERROR - no catoms in ID range\n";
            //oracleExit();
          //}
          //cID = startID;
	  //cit = worldPtr->catomHash.begin();
          //already_wrapped = true;
        //} else cID++;
        //} else cit++;
        //if ( worldPtr->catomHash.find(cID) != worldPtr->catomHash.end() ) break;
	//if ( cit!=worldPtr->catomHash.end() && cit->first >= startID && cit->first <= endID ) break;
      //}
      //cerr << "Sprinkle: using cID " << cID <<"\n";
      //cerr << "Sprinkle: using catomID " << cit->first <<"\n";
      //c = cit->second;
      if (k>=cIDs.size()) k=0;
      else k++;
      c = worldPtr->catomHash[cIDs[k]];
      cerr << "Sprinkle: using catomID " << cIDs[k] <<"\n";

      // move it to (random x, random y, Z)
      double x = Xstart + (Xend-Xstart)*(((double)rand())/RAND_MAX);
      if (! c->C.moveTo( x, Y, 1 )) { k--; n++; }  // failed to move, should try this one again
	else c->magic_force = Point3D( 0, -1, 0 )*CatomSim::catom_mass;

      // next one should arrive based on exponential interarrival times
      t += - log( ((double)rand())/RAND_MAX )/Rate;
      if ((--n)==0) break;
    }
    t -= 1.0;
    //n --;
    oracleYield();
    // running with newTick(), endTick(), other oracles
    oracleYield();
  } while ( n != 0 );

	while( 1) { oracleYield(); }

  // done
}

