/////////////////////////////////////////////////////////////////////////////////
//                                                                             //
// Copyright (C) 2006-2007 by Intel Coproration and Carnegie Mellon University //
// Contacts: casey.j.helfrich @ intel.com                                      //
//           bdr @ cs.cmu.edu                                                  //
//                                                                             //
/////////////////////////////////////////////////////////////////////////////////

#ifndef __SPECULATIONMANAGER_HXX
#define __SPECULATIONMANAGER_HXX

#include "CodeModule.hxx"
#include "Primitives.hxx"

class Message;

CODE_MODULE_PROTOTYPE( SpeculationManager, SpeculationManager );

class SpeculationManager : public CodeModule {
public:
  SpeculationManager(catomID _hostCatom);
  ~SpeculationManager();

  void newTick();
  void simulationEnd();
  void dumpStats();
  
  bool shouldEnforceMisspeculation();

  featureID speculateDestFromSourceWithMode(featureID source, string mode);

  void messageIntentArrived(Message* msg);
  void messageRouted(featureID source, featureID dest);

private:
  catomID hostCatom;
  map<featureID, featureID> lastUsed;
  map<featureID, map<featureID, unsigned long long> > history;

  unsigned long long specLastUsedCorrect;
  unsigned long long specLastUsedWrong;
  unsigned long long specMostUsedCorrect;
  unsigned long long specMostUsedWrong;

  featureID speculateMostUsed(featureID source);
  featureID speculateLastUsed(featureID source);
};


#endif
