/////////////////////////////////////////////////////////////////////////////////
//                                                                             //
// Copyright (C) 2006-2007 by Intel Coproration and Carnegie Mellon University //
// Contacts: casey.j.helfrich @ intel.com                                      //
//           bdr @ cs.cmu.edu                                                  //
//                                                                             //
/////////////////////////////////////////////////////////////////////////////////

#include "SpeculationManager.hxx"

#include "Catom.hxx"
#include "CatomSim.hxx"
#include "CatomWorld.hxx"

CODE_MODULE_DECLARATION( SpeculationManager, SpeculationManager );

SpeculationManager::SpeculationManager(catomID _hostCatom) :
  CodeModule(_hostCatom),
  hostCatom(_hostCatom)
{
  specLastUsedCorrect = 0;
  specLastUsedWrong = 0;
  specMostUsedCorrect = 0;
  specMostUsedWrong = 0;
}

SpeculationManager::~SpeculationManager() {

}

void SpeculationManager::newTick() {
  // Clear out stats after first aggregations
  if(worldPtr->current_time == 30000) {
    specLastUsedCorrect = 0;
    specLastUsedWrong = 0;
    specMostUsedCorrect = 0;
    specMostUsedWrong = 0;
  }
}

void SpeculationManager::simulationEnd() {
  string speculationDebug = worldPtr->search_key_value_list("DEBUGSPECULATION");
  if(speculationDebug == "true") {
    dumpStats();
  }
}

void SpeculationManager::dumpStats() {
  worldPtr->oStart();
  
  // Basic routing stats
  cerr << worldPtr->current_time << " Routing " << hostCatom << ":";
  for(featureID source=1; source<= NUM_FEATURES; source++) {
    cerr << " source " << (int)source << "( ";
    
    for(map<featureID, unsigned long long>::iterator iter = history[source].begin();
	iter != history[source].end();
	iter++) {
      if(iter->second) {
	cerr << (int)iter->first << ":" << iter->second << " ";
	iter->second = 0;
      }
    }
    
    cerr << ")";
  }
  cerr << endl;

  // Speculation approaches
  cerr << worldPtr->current_time << " Speculation " << hostCatom << ":";
  cerr << " lastUsed(" << specLastUsedCorrect << " " << specLastUsedWrong << ")";
  cerr << " mostUsed(" << specMostUsedCorrect << " " << specMostUsedWrong << ")";
  cerr << endl;
  
  worldPtr->oEnd();
}

bool SpeculationManager::shouldEnforceMisspeculation() {
  return true;
}

void messageIntentArrived(Message* msg) {
  
}

featureID SpeculationManager::speculateDestFromSourceWithMode(featureID source, string mode) {
  if(mode == "lastused")
    return speculateLastUsed(source);
  else if(mode == "mostused")
    return speculateMostUsed(source);
  else
    throw "Unknown speculation mode";
}

featureID SpeculationManager::speculateMostUsed(featureID source) {
  featureID mostUsedGuess = 0;
  unsigned long long mostUsedCount = 0;
  for(map<featureID, unsigned long long>::iterator iter = history[source].begin();
      iter != history[source].end();
      iter++) {
    if(iter->second > mostUsedCount) {
      mostUsedGuess = iter->first;
      mostUsedCount = iter->second;
    }
  }

  return mostUsedGuess;
}

featureID SpeculationManager::speculateLastUsed(featureID source) {
  if(lastUsed.find(source) != lastUsed.end()) {
    return lastUsed[source];
  } else {
    return 0;
  }
}

void SpeculationManager::messageRouted(featureID source, featureID dest) {
  if(lastUsed.find(source) != lastUsed.end()) {
    if(lastUsed[source] == dest)
      specLastUsedCorrect++;
    else
      specLastUsedWrong++;
  }

  featureID mostUsedGuess = speculateMostUsed(source);
  if(history[source].find(mostUsedGuess) != history[source].end()) {
    if(mostUsedGuess == dest)
      specMostUsedCorrect++;
    else
      specMostUsedWrong++;
  }

  // Update history now with the new data
  lastUsed[source] = dest;
  if(history[source].find(dest) != history[source].end())
    history[source][dest]++;
  else
    history[source][dest] = 1;
}
