///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Corporation and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef SOFTWARETIMER_HXX
#define SOFTWARETIMER_HXX


// Use make_heap, push_heap instead of priority queues.


#include "CodeModule.hxx"
#include "Network.hxx"
#include "LockInfo.hxx"
#include "MessageStructure.hxx"
//#include "STree.hxx"
#include "SoftwareTimer.hxx"
#include "CatomSim.hxx"


#include <list>
#include <queue>
#include <algorithm>

#include "CatomWorld.hxx"
#include "CodeModule.hxx"

#ifndef LOCKDBG
#define LOCKDBG 0
#endif

class CatomWorld;

extern CatomWorld* worldptr;

typedef double TimeStamp;
typedef long int TimerID;

using namespace std;

CODE_MODULE_PROTOTYPE( SoftwareTimer, SoftwareTimer );

class _SoftwareTimer {
  public:
    
    friend class PrioritizeTimer;
    
    TimeStamp timeStamp;
    void (*callbackWhenDone)(void*);
    void* obj;
    TimeStamp period;
    TimerID timerID;
    
    _SoftwareTimer(TimeStamp _ts,void (*_cb)(void*),void* _obj,TimerID _timerID, TimeStamp _per=0)
    {
      timeStamp = _ts;
      callbackWhenDone = _cb;
      obj = _obj;
      timerID = _timerID;
      period = _per;
    }
};


// class PQI : public priority_queue<int> {
//   public:
//     vector<int>& impl() { return c; }
// };

class PrioritizeTimer{
  public:
    int operator()(const _SoftwareTimer &x, const _SoftwareTimer &y)
    {
      return x.timeStamp > y.timeStamp;
    }
};

class SoftwareTimer : public CodeModule{
  protected:
    priority_queue<_SoftwareTimer,vector<_SoftwareTimer>,PrioritizeTimer> _timerQ;
    TimerID _uniqueID;
    pthread_mutex_t objectMutex; 
    vector<TimerID> _deleteTimer;
    void _unlock();
    void _lock();
    void tick(double _currtime=worldPtr->current_time);

  public:
SoftwareTimer(catomID cid): CodeModule( cid)
  {
    pthread_mutex_init(&objectMutex, NULL);_uniqueID=0;
  }
    TimerID registerTimer(TimeStamp _ts,void (*_cb)(void*),void* _obj, TimeStamp _per=0);
    TimerID deleteTimer(TimerID _tid);
    virtual void newTick();
    
    
};


#endif
