///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
 
#include "SoftwareTimer.hxx"

CODE_MODULE_DECLARATION( SoftwareTimer, SoftwareTimer );

#include "CatomSim.hxx"
#include "Catom.hxx"
#include "CatomWorld.hxx"

// TimerID SoftwareTimer::_uniqueID = 0;
// pthread_mutex_t SoftwareTimer::objectMutex = PTHREAD_MUTEX_INITIALIZER;

void SoftwareTimer::_lock()
{
  worldPtr->oStart();
  if(LOCKDBG)  cerr <<"Timer 1 Lock started"<< endl;
  worldPtr->oEnd();
    
  int err = pthread_mutex_lock(&objectMutex);
  if(err) {
    worldPtr->oStart();
    cerr << "can't lock mutex6 : " << strerror(errno) << endl;
    worldPtr->oEnd();
    exit(1);
  }
    
  worldPtr->oStart();
  if(LOCKDBG)  cerr <<"Timer Lock  1 ended"<< endl;
  worldPtr->oEnd();
}

void SoftwareTimer::_unlock()
{
    
  worldPtr->oStart();
  if(LOCKDBG)   cerr <<"Timer Unlock 1  started"<< endl;
  worldPtr->oEnd();
    
    
  int err = pthread_mutex_unlock(&objectMutex);
  if(err) {
    cerr << "can't unlock mutex : " << strerror(errno) << endl;
    exit(1);
  }
    
  worldPtr->oStart();
  if(LOCKDBG)   cerr <<"Timer Unlock 1 ended"<< endl;
  worldPtr->oEnd();
   
}
 

TimerID SoftwareTimer::registerTimer(TimeStamp _ts,void (*_cb)(void*),void* _obj, TimeStamp _per)
{
  _lock();
  _uniqueID++;
  _SoftwareTimer st = _SoftwareTimer(_ts,_cb,_obj,_uniqueID,_per);
  _timerQ.push(st);
//   worldPtr->oStart();
//   cerr<<"timerQ is now: "<<_timerQ.size()<<" at time: "<<worldPtr->current_time<<endl;
//   worldPtr->oEnd();
  _unlock();
  return _uniqueID;
}
 
TimerID SoftwareTimer::deleteTimer(TimerID _tid)
{
  _lock();
  if(_tid>0) 
  {
    _deleteTimer.push_back(_tid);
    _tid = 0;
  }
  _unlock();
  return _tid;
}

void SoftwareTimer::tick(double _currtime)
{
  _lock();
//   worldPtr->oStart();
//   cerr<<"timerQ is now: "<<_timerQ.size()<<" at time: "<<worldPtr->current_time<<endl;
//   worldPtr->oEnd();
  while(!_timerQ.empty())
  {  
    _SoftwareTimer _st = _timerQ.top();
    
//     worldPtr->oStart();
//     cerr<<"timerQ top time is: "<<_st.timeStamp<<" at time: "<<worldPtr->current_time<<endl;
//     worldPtr->oEnd();
    
    if(_st.timeStamp>_currtime)
      break;
    

    vector<TimerID>::iterator it = find(_deleteTimer.begin(),_deleteTimer.end(),_st.timerID);
    if(it!=_deleteTimer.end())
    {
      _timerQ.pop();
      _deleteTimer.erase(it);
    }
    else
    {
      _timerQ.pop();
      if(_st.period!=0)
      {
	_st.timeStamp+=_st.period;
	_timerQ.push(_st);
      }
	
      _unlock();
      _st.callbackWhenDone(_st.obj);  
      _lock();      
    }
  }
  _unlock();
  
//   worldPtr->oStart();
//   cerr<<"timerQ is done: "<<_timerQ.size()<<" at time: "<<worldPtr->current_time<<endl;
//   worldPtr->oEnd();
}

void SoftwareTimer::newTick()
{
  tick();
}
