///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2007 by Intel Corporation and Carnegie Mellon University    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __SHIFTINIT_H
#define __SHIFTINIT_H

#include "CodeModule.hxx"
#include "CatomWorld.hxx"
#include <fstream>

CODE_MODULE_PROTOTYPE( ShiftInit, ShiftInit );
using namespace std;

extern CatomWorld *worldPtr;

class ShiftInit : public CodeModule {
	static double shiftx, shifty, shiftz;
	static ifstream binin;
	static int startnum;
	static int endnum;
	static int switchnum;
	static string binin_file;
	static bool use_binin;
	static bool use_lines;
	static catomID master;
	static unsigned int color;
	static unsigned int newcolor;
	static int hack_meta;
	void do_binin();
public:
	ShiftInit(catomID _hostCatom) : CodeModule(_hostCatom) {
		if (_hostCatom) {
			if (master==0) master = _hostCatom;  // catoms constructed one at a time, so safe
			const dReal* p = dBodyGetPosition( HOSTCATOMSIM->body );
			dBodySetPosition( HOSTCATOMSIM->body, p[0]+shiftx, p[1]+shifty, p[2]+shiftz );
			if (color!=0xffffffff) {
				HOSTCATOMSIM->red = (color & 0xff000000)>>24;
				HOSTCATOMSIM->green = (color & 0xff0000)>>16;
				HOSTCATOMSIM->blue = (color & 0xff00)>>8;
				HOSTCATOMSIM->alpha = (color & 0xff);
			}
			if (hack_meta==100) HOSTCATOMSIM->HACK_metamodule = (_hostCatom & 0x1)+1;
			else if (hack_meta>=0) HOSTCATOMSIM->HACK_metamodule = hack_meta;
		} else {
			string tmp;
			tmp = worldPtr->search_key_value_list( "ShiftInit_x" );
			if (tmp!="") shiftx = strtod( tmp.c_str(), 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_y" );
			if (tmp!="") shifty = strtod( tmp.c_str(), 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_z" );
			if (tmp!="") shiftz = strtod( tmp.c_str(), 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_binfile" );
			if (tmp!="") { use_binin = true; binin_file=tmp; }
			tmp = worldPtr->search_key_value_list( "ShiftInit_color" );
			if (tmp!="") color = strtoul( tmp.c_str(), 0, 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_newcolor" );
			if (tmp!="") newcolor = strtoul( tmp.c_str(), 0, 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_hack_meta" );
			if (tmp!="") hack_meta = strtol( tmp.c_str(), 0, 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_startfilenum" );
			if (tmp!="") startnum = strtol( tmp.c_str(), 0, 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_endfilenum" );
			if (tmp!="") endnum = strtol( tmp.c_str(), 0, 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_switchnum" );
			if (tmp!="") switchnum = strtol( tmp.c_str(), 0, 0);
			tmp = worldPtr->search_key_value_list( "ShiftInit_use_lines" );
			if (tmp=="true") use_lines=true; else use_lines=false;
		}
	};
	virtual void simulationStart();
	virtual void newTick();
};

#endif
