///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2007 by Intel Corporation and Carnegie Mellon University    //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include "ShiftInit.hxx"
#include "assert.h"
#include "stdio.h"

CODE_MODULE_DECLARATION( ShiftInit, ShiftInit );

catomID ShiftInit::master = 0;
double ShiftInit::shiftx = 0;
double ShiftInit::shifty = 0;
double ShiftInit::shiftz = 0;
ifstream ShiftInit::binin;
bool ShiftInit::use_binin = false;
int ShiftInit::startnum=1;
int ShiftInit::endnum=0;
string ShiftInit::binin_file;
unsigned int ShiftInit::color=0xffffffff;
unsigned int ShiftInit::newcolor=0xffffffff;
int ShiftInit::switchnum=0;
int ShiftInit::hack_meta=-1;
bool ShiftInit::use_lines=false;

static struct binin_header {
	int LOCS;
	int ver;
	int dim;
	int num_catoms;
	int nrecs;
} header;

static struct rec_header {
	double time, foo, bar;
} this_rec_head;

static struct binin_record3d {
	double id;
	double x, y, z, qw, qx, qy, qz;
} record;

static struct binin_record2d {
	double id, x, y, th;    // check this -- id first or last?
} record2;

void ShiftInit::do_binin() {
	
	binin.read( (char*) &header, sizeof(binin_header) );
	assert( header.ver==2 );
	assert( header.dim==3 || header.dim==2 );
	assert( header.num_catoms = worldPtr->catomHash.size() );
	binin.read( (char*) &this_rec_head, sizeof( rec_header) );
	int i;
	if ( header.dim==2 ) for ( i=0; i<header.num_catoms; i++ ) {
		binin.read( (char*) &record2, sizeof( binin_record2d ) );
		catomID cid = record2.id;
		//cerr << cid << " " << record2.x << " " << record2.y << " " << record2.th << endl;
		CatomSim* c = worldPtr->catomHash[cid];
		dBodySetPosition( c->body, record2.x+shiftx, record2.y+shifty, 
					CatomSim::catom_radius+shiftz );
		dQuaternion q;
		dQFromAxisAndAngle( q, 0, 0, 1, record2.th );
		dBodySetQuaternion( c->body, q );
	}
	else for ( i=0; i<header.num_catoms; i++ ) {
		binin.read( (char*) &record, sizeof( binin_record3d ) );
		catomID cid = record.id;
		//cerr << cid << " " << record.x << " " << record.y << " " << record.z << " " << record.qw << " " << record.qx << " " << record.qy << " " << record.qz << endl;
		CatomSim* c = worldPtr->catomHash[cid];
		dBodySetPosition( c->body, record.x+shiftx, record.y+shifty, record.z+shiftz );
		dReal q[4];
		q[0] = record.qw;
		q[1] = record.qx;
		q[2] = record.qy;
		q[3] = record.qz;
		dBodySetQuaternion( c->body, q );
	}
}


void ShiftInit::simulationStart() {
	if (use_binin && master==HOSTCATOM.getID() && startnum>endnum) {
		cerr << "ShiftInit: reading " << binin_file << endl;
		binin.open( binin_file.c_str(), ifstream::binary );
		do_binin();
		binin.close();
		if (use_lines) {
		}
	}
}

static char fname[1024];

void ShiftInit::newTick() {
	if (use_binin && master==HOSTCATOM.getID() && startnum<=endnum) {
		static bool first_time = true;
		if (first_time) first_time=false;  // simulator does 2 steps before first displayed image!!!
		else {
			static unsigned long oldcolor=color;
			snprintf( fname, 1024, binin_file.c_str(), startnum );
			cerr << "ShiftInit: reading " << fname << endl;
			binin.open( fname, ifstream::binary );
			do_binin();
			binin.close();
			if (startnum==switchnum) { oldcolor=color; color=newcolor; }
			if (use_lines) {
				if (startnum==switchnum) { use_lines=!use_lines; }
				CatomSim::updateAllNeighbors();
				worldPtr->clearLines();
				hash_map<const unsigned long,CatomSim*, hash<const unsigned long>, equl>::const_iterator cid= worldPtr->catomHash.begin();
				while( cid!=worldPtr->catomHash.end() ) {
					int i;
					catomID ca = cid->second->C.getID();
					if (color!=0xffffffff) {
						worldPtr->catomHash[ca]->red = (color & 0xff000000)>>24;
						worldPtr->catomHash[ca]->green = (color & 0xff0000)>>16;
						worldPtr->catomHash[ca]->blue = (color & 0xff00)>>8;
						worldPtr->catomHash[ca]->alpha = (color & 0xff);
					}
					if (use_lines) for (i=1; i<=NUM_FEATURES; i++) {
						catomID cb = cid->second->C.getNeighbor(i);
						if (cb) worldPtr->addLine(ca,cb,255,0,0);
					}
					cid++;
				}
			}
			startnum++;
			if (startnum>endnum) { startnum=1; color=oldcolor; if (switchnum>0) use_lines=!use_lines; }
		}
	}
}
