///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef SHAPE_MOTION_HXX
#define SHAPE_MOTION_HXX


#include "CodeModule.hxx"
#include "Network.hxx"
#include "LockInfo.hxx"
#include "MessageStructure.hxx"
//#include "STree.hxx"
#include "SoftwareTimer.hxx"
#include <list>

class Catom;
class Message;
class LockInfo;
class STMessage;


using namespace std;

CODE_MODULE_PROTOTYPE( ShapeMotion, ShapeMotion );


class ShapeMotion : public CodeModule {
  public:
	
  //STree stree;
    LockInfo *lockList; // List of locks 
    static pthread_mutex_t objectMutex; 
    Catom *me;
    
    // store pointer to current CM and targetCM
    Point3D currEstimateCM;
    Point3D targetCM;
    double updateTime;
    double lambda;

  public:
	
    ShapeMotion(catomID cid) : CodeModule(cid)
    { 
      updateTime = 1;
    }
    void simulationStart();
    bool messageHandler(STMessage* msg);
    bool lockMessageHandler(LockMessage* msg);
    
    static void actionDoer(void* ptrToObj);
    vector<featureID> getNeighbors(catomID c = 0);

  protected:
    
    void getEmptyNeighbors(vector<featureID> fid);
    void _actionDoer();
    
    vector<Point3D> empty_neighbors;
    vector<bool> en_movestatus;
    vector<long> en_support;
    vector<catomID> potentialLeaders;
    
    void _lock();
    void _unlock();
    void _sendHandler(STMessage* msg);
    void _reqHandler(STMessage* msg);
    
    virtual void newTick();	
    virtual void endTick();
};




#endif //SHAPE_MOTION_HXX
