///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: raam @ cmu.edu                                                  //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream> 

#include "ShapeMotion.hxx"
#include "DConsensus.hxx"

CODE_MODULE_DECLARATION( ShapeMotion, ShapeMotion );


#include "Catom.hxx"
#include "CatomWorld.hxx"
#include "Network.hxx"
#include "CatomSim.hxx"

using namespace std;

pthread_mutex_t ShapeMotion::objectMutex = PTHREAD_MUTEX_INITIALIZER;

void ShapeMotion::simulationStart()
{ 
  lockList = new LockInfo(hostCatom);
  //stree = STree(hostCatom,lockList);
  me = &HOSTCATOM;
  currEstimateCM = me->getLocation();
  lambda = 0.1;
  targetCM = Point3D(30,5,1);
  me->setColor(200,0,0,160);

  CODE_MODULE(SoftwareTimer)->registerTimer(80+rand()%30,&ShapeMotion::actionDoer,this,80);
  CODE_MODULE(DConsensus)->updateState(10,currEstimateCM.getX());
  CODE_MODULE(DConsensus)->updateState(11,currEstimateCM.getY());
  CODE_MODULE(DConsensus)->updateState(12,currEstimateCM.getZ());

  
}

void ShapeMotion::getEmptyNeighbors(vector<featureID> fid)
{
  // NUM_FEATURES
  bool npresent[6];
  vector<long> nbs;  
  empty_neighbors.clear();
  nbs.clear();
  
  for(uint i=0;i<fid.size();i++)
    fid[i]--;

  for(uint i=0;i<6;i++)
  {
    if(find(fid.begin(),fid.end(),i)==fid.end())
    {
      npresent[i]=false;
      empty_neighbors.push_back(me->getNeighborCenter(i+1));
      nbs.push_back(-1);
    }
    else
    {
      npresent[i] = true;
      nbs.push_back(i);
    }
  }
  en_movestatus.clear();
  en_support.clear();
  for(uint i=0;i<6;i++)
  {
    if(npresent[i]==false) // hole
    {
			// is there is a support and a gateway ?
      if((npresent[(i+6+1)%6] && !npresent[(i+6-1)%6]) || 
         (!npresent[(i+6+1)%6] && npresent[(i+6-1)%6])) 
      {
        en_movestatus.push_back(true);
				// calculate support neigbor
        if(npresent[(i+6+1)%6])
          en_support.push_back(nbs[(i+6+1)%6]+1);
        else
          en_support.push_back(nbs[(i+6-1)%6]+1);
      }
      else
      {
        en_movestatus.push_back(false);
        en_support.push_back(-1);
      }
    }
  }
}

void ShapeMotion::actionDoer(void* ptrToObj)
{
  ((ShapeMotion*)(ptrToObj))->_actionDoer();
}

vector<featureID> ShapeMotion::getNeighbors(catomID c)
{
  if(c==0) 
    c = me->getID();
  vector<featureID> f;
  for(featureID fid =1;fid<=NUM_FEATURES;fid++)
    if(worldPtr->catomHash[c]->C.getNeighbor(fid) != 0)
      f.push_back(fid);
  return f;
}


void ShapeMotion::_actionDoer()
{
  currEstimateCM.setX( CODE_MODULE(DConsensus)->getState(10));
  currEstimateCM.setY( CODE_MODULE(DConsensus)->getState(11));
  currEstimateCM.setZ( CODE_MODULE(DConsensus)->getState(12));
  
  _lock();
  long int fLockID = rand();
  if(!lockList->addLock(fLockID, LOCK_MOTION_CLASS, me->getID(), worldPtr->current_time+10))
  {
    _unlock();
    return;
  }
  
  vector<featureID> vecF = getNeighbors();
  getEmptyNeighbors(vecF);
  
  short movehole = -1;
  Point3D difference,minVector;
  double minDotProduct=0, dotProduct;
  for(uint i=0;i<empty_neighbors.size();i++)
  {
    if(en_movestatus[i]==false) // we don't want to consider holes which don't have support
      continue;
      // calculate dot product..
    difference=empty_neighbors[i]-me->getLocation();
    difference/=difference.norm();
    Point3D dirVector = targetCM - currEstimateCM;
    dirVector = dirVector/dirVector.norm();
    dotProduct=difference.dot(dirVector);
    if(dotProduct>minDotProduct && dotProduct>=0)
    {
        movehole=i;
        minDotProduct=dotProduct;
        minVector=difference;
    }
  }
  //  if((targetCM - currEstimateCM).norm()<1);
  //  movehole = -1;

  if(movehole==-1) // there is not a single hole without support
  {
    lockList->removeLock(fLockID);
    _unlock();
    return ;
  }
  
  for(uint i=1;i<=NUM_FEATURES;i++)
    if(me->getNeighbor(i)!=0 
       && getNeighbors(me->getNeighbor(i)).size()==1)
    {
      if(getNeighbors().size()==1)
        break;
      lockList->removeLock(fLockID);
      _unlock();
      return ;
    }
  
  featureID supportFID = en_support[movehole];
  catomID supportCatomID = me->getNeighbor(supportFID);
  
  Point3D destPt = empty_neighbors[movehole];
  featureID nfid = worldPtr->catomHash[supportCatomID]->C.getNearestFeature(destPt);

  currEstimateCM-=me->getLocation();
  me->moveTo(supportCatomID,nfid);
  currEstimateCM+=me->getLocation();
  
  lockList->removeLock(fLockID);
  _unlock();
  
  CODE_MODULE(DConsensus)->updateState(10,me->getLocation().getX());
  CODE_MODULE(DConsensus)->updateState(11,me->getLocation().getY());
  CODE_MODULE(DConsensus)->updateState(12,me->getLocation().getZ());
  
//   worldPtr->clearLines(hostCatom);

  
}

void ShapeMotion::endTick()
{
  
}

#define DCDBG 0

void ShapeMotion::_lock()
{
  if(DCDBG) worldPtr->oStart();
  if(DCDBG) cerr << "Lock try_1" << endl;
  if(DCDBG) worldPtr->oEnd();

  int err = pthread_mutex_lock(&objectMutex);
  if(err) {
    worldPtr->oStart();
  cerr << "can't lock mutex5 : " << strerror(errno) << endl;
    worldPtr->oEnd();
    exit(1);
  }
  
  if(DCDBG) worldPtr->oStart();
  if(DCDBG) cerr << "Lock successful_1" << endl;
  if(DCDBG) worldPtr->oEnd();

}

void ShapeMotion::_unlock()
{
  
  if(DCDBG) worldPtr->oStart();
  if(DCDBG) cerr << "unlock try_1" << endl;
  if(DCDBG) worldPtr->oEnd();
  
  int err = pthread_mutex_unlock(&objectMutex);
  if(err) {
  cerr << "can't unlock mutex : " << strerror(errno) << endl;
    exit(1);
  }
  
  if(DCDBG) worldPtr->oStart();
  if(DCDBG) cerr << "unlock successful_1" << endl;
  if(DCDBG) worldPtr->oEnd();
}

void ShapeMotion::newTick()
{
  currEstimateCM.setX( CODE_MODULE(DConsensus)->getState(10));
  currEstimateCM.setY( CODE_MODULE(DConsensus)->getState(11));
  currEstimateCM.setZ( CODE_MODULE(DConsensus)->getState(12));

  //cerr<<hostCatom<<" curr estimate: "<<currEstimateCM.toString()<<endl; 
  worldPtr->clearLines(hostCatom);
  worldPtr->addLine(hostCatom,currEstimateCM,0,0,200);
  worldPtr->addLine(hostCatom,targetCM,0,100,0);
  

//   CODE_MODULE(DConsensus)->updateState(10,currEstimateCM.getX());
//   CODE_MODULE(DConsensus)->updateState(11,currEstimateCM.getY());
//   CODE_MODULE(DConsensus)->updateState(12,currEstimateCM.getZ());
}
