///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Copyright (C) 2006 by Intel Coproration and Carnegie Mellon University    //
// Contacts: casey.j.helfrich @ intel.com                                    //
//           bdr @ cs.cmu.edu                                                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#include <iostream>
#include <errno.h>
#include <string.h>

#include "RandomValue.hxx"
#include "CatomSim.hxx"
#include "CatomWorld.hxx"

CODE_MODULE_DECLARATION( RandomValue, RandomValue );

using namespace std;

void RandomValue::simulationStart() {
  value = 0;
  value2 = 0;
  value3 = 0;
  value4 = 0;
  value5 = 0;
	
	string size_str = worldPtr->search_key_value_list("RV1"); 
	size = 2;
	if (size_str != "") {
		char *endptr;
		size = (unsigned) strtoul( size_str.c_str(), &endptr, 0);
	}
	size_str = worldPtr->search_key_value_list("RV2"); 
	size2 = 2;
	if (size_str != "") {
		char *endptr;
		size2 = (unsigned) strtoul( size_str.c_str(), &endptr, 0);
	}
	size_str = worldPtr->search_key_value_list("RV3"); 
	size3 = 2;
	if (size_str != "") {
		char *endptr;
		size3 = (unsigned) strtoul( size_str.c_str(), &endptr, 0);
	}
	size_str = worldPtr->search_key_value_list("RV4"); 
	size4 = 2;
	if (size_str != "") {
		char *endptr;
		size4 = (unsigned) strtoul( size_str.c_str(), &endptr, 0);
	}
	size_str = worldPtr->search_key_value_list("RV5"); 
	size5 = 2;
	if (size_str != "") {
		char *endptr;
		size5 = (unsigned) strtoul( size_str.c_str(), &endptr, 0);
	}
}

void RandomValue::newTick() {
  value = size ? rand() % size : 0;
  value2 = size2 ? rand() % size2 : 0;
  value3 = size3 ? rand() % size3 : 0;
  value4 = size4 ? rand() % size4 : 0;
  value5 = size5 ? rand() % size5 : 0;
  if (value) {
    worldPtr->catomHash[hostCatom]->red = 255;
    worldPtr->catomHash[hostCatom]->green = 255;
    worldPtr->catomHash[hostCatom]->blue = 0;
    worldPtr->catomHash[hostCatom]->alpha = 100;
  }
  else {
    worldPtr->catomHash[hostCatom]->red = 0;
    worldPtr->catomHash[hostCatom]->green = 0;
    worldPtr->catomHash[hostCatom]->blue = 0;
    worldPtr->catomHash[hostCatom]->alpha = 100;
  }
  
}

void RandomValue::endTick() {
  
}
